/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.invariant;

import java.util.function.Function;

public final class LongRangeUtil {
    private LongRangeUtil() {
    }

    public static long requirePositive(long val) {
        if (val < 1L) {
            throw new IllegalArgumentException(val + " is not positive.");
        }
        return val;
    }

    public static long requireNegative(long val) {
        if (val > -1L) {
            throw new IllegalArgumentException(val + " is not negative.");
        }
        return val;
    }

    public static long requireZero(long val) {
        if (val != 0L) {
            throw new IllegalArgumentException(val + " is not zero.");
        }
        return val;
    }

    public static long requireNonPositive(long val) {
        if (val > 0L) {
            throw new IllegalArgumentException(val + " is positive.");
        }
        return val;
    }

    public static long requireNonNegative(long val) {
        if (val < 0L) {
            throw new IllegalArgumentException(val + " is negative.");
        }
        return val;
    }

    public static long requireNonZero(long val) {
        if (val == 0L) {
            throw new IllegalArgumentException(val + " is zero.");
        }
        return val;
    }

    public static long requireEquals(long val, long otherVal) {
        if (val != otherVal) {
            throw new IllegalArgumentException(val + " is not equal to " + otherVal);
        }
        return val;
    }

    public static long requireNotEquals(long val, long otherVal) {
        if (val == otherVal) {
            throw new IllegalArgumentException(val + " is equal to." + otherVal);
        }
        return val;
    }

    public static long requireInRange(long val, long first, long lastExclusive) {
        if (val < first || val >= lastExclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + first + ", " + lastExclusive + ")");
        }
        return val;
    }

    public static long requireInRangeClosed(long val, long first, long lastInclusive) {
        if (val < first || val > lastInclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + first + ", " + lastInclusive + "]");
        }
        return val;
    }

    public static <E extends RuntimeException> long requirePositive(long val, Function<String, E> exceptionConstructor) {
        if (val < 1L) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not positive.");
        }
        return val;
    }

    public static <E extends RuntimeException> long requireNegative(long val, Function<String, E> exceptionConstructor) {
        if (val > -1L) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not negative.");
        }
        return val;
    }

    public static <E extends RuntimeException> long requireZero(long val, Function<String, E> exceptionConstructor) {
        if (val != 0L) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not zero.");
        }
        return val;
    }

    public static <E extends RuntimeException> long requireNonPositive(long val, Function<String, E> exceptionConstructor) {
        if (val > 0L) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is positive.");
        }
        return val;
    }

    public static <E extends RuntimeException> long requireNonNegative(long val, Function<String, E> exceptionConstructor) {
        if (val < 0L) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is negative.");
        }
        return val;
    }

    public static <E extends RuntimeException> long requireNonZero(long val, Function<String, E> exceptionConstructor) {
        if (val == 0L) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is zero.");
        }
        return val;
    }

    public static <E extends RuntimeException> long requireEquals(long val, long otherVal, Function<String, E> exceptionConstructor) {
        if (val != otherVal) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not equal to " + otherVal);
        }
        return val;
    }

    public static <E extends RuntimeException> long requireNotEquals(long val, long otherVal, Function<String, E> exceptionConstructor) {
        if (val == otherVal) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is equal to." + otherVal);
        }
        return val;
    }

    public static <E extends RuntimeException> long requireInRange(long val, long first, long lastExclusive, Function<String, E> exceptionConstructor) {
        if (val < first || val >= lastExclusive) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not in the range [" + first + ", " + lastExclusive + ")");
        }
        return val;
    }

    public static <E extends RuntimeException> long requireInRangeClosed(long val, long first, long lastInclusive, Function<String, E> exceptionConstructor) {
        if (val < first || val > lastInclusive) {
            throw (RuntimeException)exceptionConstructor.apply(val + " is not in the range [" + first + ", " + lastInclusive + "]");
        }
        return val;
    }
}

