/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.json.internal;

import com.speedment.common.json.JsonSyntaxException;
import com.speedment.common.json.exception.JsonException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class JsonDeserializer
implements AutoCloseable {
    private static final String UNKNOWN_ENUM_CONSTANT = "Unknown enum constant '";
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final int TAB_SIZE = 4;
    private final InputStreamReader reader;
    private final AtomicLong row;
    private final AtomicLong col;
    private int character;

    public JsonDeserializer(InputStream in) {
        this.reader = new InputStreamReader(in, ENCODING);
        this.row = new AtomicLong(0L);
        this.col = new AtomicLong(0L);
    }

    public Object get() throws IOException {
        int nextNonBlankspace = this.nextNonBlankspace();
        switch (nextNonBlankspace) {
            case 123: {
                return this.parseObject();
            }
            case 91: {
                return this.parseArray();
            }
            case 34: {
                return this.parseString();
            }
            case 102: {
                return this.parseFalse();
            }
            case 116: {
                return this.parseTrue();
            }
            case 110: {
                return this.parseNull();
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                AtomicReference number = new AtomicReference();
                CloseMethod closeMethod = this.parseNumber(number::set);
                if (closeMethod == CloseMethod.NOT_DECIDED) {
                    return number.get();
                }
                throw new JsonSyntaxException(this.row, this.col, "parseNumber should return " + (Object)((Object)CloseMethod.NOT_DECIDED) + " but actually returned: " + (Object)((Object)closeMethod));
            }
        }
        throw this.unexpectedCharacterException();
    }

    private Map<String, Object> parseObject() throws IOException {
        CloseMethod close;
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        block0 : switch (this.nextNonBlankspace()) {
            case 125: {
                return object;
            }
            case 34: {
                close = this.parseEntryInto(object);
                switch (close) {
                    case EXIT_FROM_PARENT: {
                        if (this.character == 125) {
                            return object;
                        }
                        throw this.unexpectedCharacterException();
                    }
                    case CONTINUE_IN_PARENT: {
                        break block0;
                    }
                    case NOT_DECIDED: {
                        switch (this.nextNonBlankspace()) {
                            case 44: {
                                break block0;
                            }
                            case 125: {
                                return object;
                            }
                        }
                        throw this.unexpectedCharacterException();
                    }
                }
                throw new IllegalStateException(UNKNOWN_ENUM_CONSTANT + (Object)((Object)close) + "'.");
            }
            default: {
                throw this.unexpectedCharacterException();
            }
        }
        block22: while (this.nextNonBlankspace() == 34) {
            close = this.parseEntryInto(object);
            switch (close) {
                case EXIT_FROM_PARENT: {
                    if (this.character == 125) {
                        return object;
                    }
                    throw this.unexpectedCharacterException();
                }
                case CONTINUE_IN_PARENT: {
                    continue block22;
                }
                case NOT_DECIDED: {
                    switch (this.nextNonBlankspace()) {
                        case 44: {
                            continue block22;
                        }
                        case 125: {
                            return object;
                        }
                    }
                    throw this.unexpectedCharacterException();
                }
            }
            throw new IllegalStateException(UNKNOWN_ENUM_CONSTANT + (Object)((Object)close) + "'.");
        }
        throw this.unexpectedCharacterException();
    }

    private CloseMethod parseEntryInto(Map<String, Object> object) throws IOException {
        StringBuilder keyBuilder = new StringBuilder();
        block13: while (true) {
            switch (this.next()) {
                case 92: {
                    keyBuilder.append(Character.toChars(this.next()));
                    continue block13;
                }
                case 34: {
                    break block13;
                }
                default: {
                    keyBuilder.append(Character.toChars(this.character));
                    continue block13;
                }
            }
            break;
        }
        String key = keyBuilder.toString();
        if (this.nextNonBlankspace() != 58) {
            throw this.unexpectedCharacterException();
        }
        switch (this.nextNonBlankspace()) {
            case 123: {
                this.putIfUniqueOrThrow(object, key, this.parseObject());
                return CloseMethod.NOT_DECIDED;
            }
            case 91: {
                this.putIfUniqueOrThrow(object, key, this.parseArray());
                return CloseMethod.NOT_DECIDED;
            }
            case 34: {
                this.putIfUniqueOrThrow(object, key, this.parseString());
                return CloseMethod.NOT_DECIDED;
            }
            case 102: {
                this.putIfUniqueOrThrow(object, key, this.parseFalse());
                return CloseMethod.NOT_DECIDED;
            }
            case 116: {
                this.putIfUniqueOrThrow(object, key, this.parseTrue());
                return CloseMethod.NOT_DECIDED;
            }
            case 110: {
                this.putIfUniqueOrThrow(object, key, this.parseNull());
                return CloseMethod.NOT_DECIDED;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.parseNumber(num -> this.putIfUniqueOrThrow(object, key, num));
            }
        }
        throw this.unexpectedCharacterException();
    }

    private List<Object> parseArray() throws IOException {
        LinkedList<Object> list = new LinkedList<Object>();
        block0 : switch (this.nextNonBlankspace()) {
            case 93: {
                return list;
            }
            case 123: {
                list.add(this.parseObject());
                switch (this.nextNonBlankspace()) {
                    case 44: {
                        break block0;
                    }
                    case 93: {
                        return list;
                    }
                }
                throw this.unexpectedCharacterException();
            }
            case 91: {
                list.add(this.parseArray());
                switch (this.nextNonBlankspace()) {
                    case 44: {
                        break block0;
                    }
                    case 93: {
                        return list;
                    }
                }
                throw this.unexpectedCharacterException();
            }
            case 34: {
                list.add(this.parseString());
                switch (this.nextNonBlankspace()) {
                    case 44: {
                        break block0;
                    }
                    case 93: {
                        return list;
                    }
                }
                throw this.unexpectedCharacterException();
            }
            case 102: {
                list.add(this.parseFalse());
                switch (this.nextNonBlankspace()) {
                    case 44: {
                        break block0;
                    }
                    case 93: {
                        return list;
                    }
                }
                throw this.unexpectedCharacterException();
            }
            case 116: {
                list.add(this.parseTrue());
                switch (this.nextNonBlankspace()) {
                    case 44: {
                        break block0;
                    }
                    case 93: {
                        return list;
                    }
                }
                throw this.unexpectedCharacterException();
            }
            case 110: {
                list.add(this.parseNull());
                switch (this.nextNonBlankspace()) {
                    case 44: {
                        break block0;
                    }
                    case 93: {
                        return list;
                    }
                }
                throw this.unexpectedCharacterException();
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                CloseMethod method = this.parseNumber(list::add);
                switch (method) {
                    case CONTINUE_IN_PARENT: {
                        break block0;
                    }
                    case EXIT_FROM_PARENT: {
                        if (this.character == 93) {
                            return list;
                        }
                        throw this.unexpectedCharacterException();
                    }
                    case NOT_DECIDED: {
                        switch (this.nextNonBlankspace()) {
                            case 44: {
                                break block0;
                            }
                            case 93: {
                                return list;
                            }
                        }
                        throw this.unexpectedCharacterException();
                    }
                }
                throw new IllegalStateException(UNKNOWN_ENUM_CONSTANT + (Object)((Object)method) + "'.");
            }
            default: {
                throw this.unexpectedCharacterException();
            }
        }
        return this.parseEachRemainingEntry(list);
    }

    private List<Object> parseEachRemainingEntry(List<Object> list) throws IOException {
        block22: while (true) {
            switch (this.nextNonBlankspace()) {
                case 123: {
                    list.add(this.parseObject());
                    break;
                }
                case 91: {
                    list.add(this.parseArray());
                    break;
                }
                case 34: {
                    list.add(this.parseString());
                    break;
                }
                case 102: {
                    list.add(this.parseFalse());
                    break;
                }
                case 116: {
                    list.add(this.parseTrue());
                    break;
                }
                case 110: {
                    list.add(this.parseNull());
                    break;
                }
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    CloseMethod method = this.parseNumber(list::add);
                    switch (method) {
                        case CONTINUE_IN_PARENT: {
                            continue block22;
                        }
                        case EXIT_FROM_PARENT: {
                            if (this.character == 93) {
                                return list;
                            }
                            throw this.unexpectedCharacterException();
                        }
                        case NOT_DECIDED: {
                            switch (this.nextNonBlankspace()) {
                                case 44: {
                                    continue block22;
                                }
                                case 93: {
                                    return list;
                                }
                            }
                            throw this.unexpectedCharacterException();
                        }
                    }
                    throw new IllegalStateException(UNKNOWN_ENUM_CONSTANT + (Object)((Object)method) + "'.");
                }
                default: {
                    throw this.unexpectedCharacterException();
                }
            }
            switch (this.nextNonBlankspace()) {
                case 44: {
                    continue block22;
                }
                case 93: {
                    return list;
                }
            }
            break;
        }
        throw this.unexpectedCharacterException();
    }

    private String parseString() throws IOException {
        StringBuilder builder = new StringBuilder();
        block13: while (true) {
            switch (this.next()) {
                case 92: {
                    int n = this.next();
                    switch (n) {
                        case 34: {
                            builder.append('\"');
                            continue block13;
                        }
                        case 98: {
                            builder.append('\b');
                            continue block13;
                        }
                        case 102: {
                            builder.append('\f');
                            continue block13;
                        }
                        case 110: {
                            builder.append('\n');
                            continue block13;
                        }
                        case 114: {
                            builder.append('\r');
                            continue block13;
                        }
                        case 116: {
                            builder.append('\t');
                            continue block13;
                        }
                        case 92: {
                            builder.append('\\');
                            continue block13;
                        }
                    }
                    builder.append('\\').appendCodePoint(n);
                    continue block13;
                }
                case 34: {
                    return builder.toString();
                }
            }
            builder.append(Character.toChars(this.character));
        }
    }

    private Boolean parseFalse() throws IOException {
        if (this.next() == 97 && this.next() == 108 && this.next() == 115 && this.next() == 101) {
            return Boolean.FALSE;
        }
        throw this.unexpectedCharacterException();
    }

    private Boolean parseTrue() throws IOException {
        if (this.next() == 114 && this.next() == 117 && this.next() == 101) {
            return Boolean.TRUE;
        }
        throw this.unexpectedCharacterException();
    }

    private Object parseNull() throws IOException {
        if (this.next() == 117 && this.next() == 108 && this.next() == 108) {
            return null;
        }
        throw this.unexpectedCharacterException();
    }

    private CloseMethod parseNumber(Consumer<Number> consumer) throws IOException {
        CloseMethod method;
        StringBuilder builder = new StringBuilder();
        block10: while (true) {
            switch (this.character) {
                case 46: {
                    builder.append('.');
                    return this.parseNumberDecimal(consumer, builder);
                }
                case 45: {
                    builder.append('-');
                    this.next();
                    continue block10;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    builder.append(Character.toChars(this.character));
                    this.next();
                    continue block10;
                }
                case 93: 
                case 125: {
                    method = CloseMethod.EXIT_FROM_PARENT;
                    break block10;
                }
                case 44: {
                    method = CloseMethod.CONTINUE_IN_PARENT;
                    break block10;
                }
                case 10: {
                    this.row.incrementAndGet();
                    this.col.set(-1L);
                    method = CloseMethod.NOT_DECIDED;
                    break block10;
                }
                case 9: {
                    this.col.addAndGet(3L);
                    method = CloseMethod.NOT_DECIDED;
                    break block10;
                }
                case 13: 
                case 32: {
                    method = CloseMethod.NOT_DECIDED;
                    break block10;
                }
                default: {
                    throw this.unexpectedCharacterException();
                }
            }
            break;
        }
        consumer.accept(Long.parseLong(builder.toString()));
        return method;
    }

    private CloseMethod parseNumberDecimal(Consumer<Number> consumer, StringBuilder builder) throws IOException {
        CloseMethod method;
        block8: while (true) {
            switch (this.next()) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    builder.append(Character.toChars(this.character));
                    continue block8;
                }
                case 93: 
                case 125: {
                    method = CloseMethod.EXIT_FROM_PARENT;
                    break block8;
                }
                case 44: {
                    method = CloseMethod.CONTINUE_IN_PARENT;
                    break block8;
                }
                case 10: {
                    this.row.incrementAndGet();
                    this.col.set(-1L);
                    method = CloseMethod.NOT_DECIDED;
                    break block8;
                }
                case 9: {
                    this.col.addAndGet(3L);
                    method = CloseMethod.NOT_DECIDED;
                    break block8;
                }
                case 13: 
                case 32: {
                    method = CloseMethod.NOT_DECIDED;
                    break block8;
                }
                default: {
                    throw this.unexpectedCharacterException();
                }
            }
            break;
        }
        String result = builder.toString();
        if (result.equals(".")) {
            throw new JsonSyntaxException(this.row, this.col, "Unexpected character '.'");
        }
        consumer.accept(Double.parseDouble(builder.toString()));
        return method;
    }

    private int nextNonBlankspace() throws IOException {
        block5: while ((this.character = this.reader.read()) != -1) {
            this.col.incrementAndGet();
            switch (this.character) {
                case 10: {
                    this.row.incrementAndGet();
                    this.col.set(-1L);
                    continue block5;
                }
                case 9: {
                    this.col.addAndGet(3L);
                    continue block5;
                }
                case 13: 
                case 32: {
                    continue block5;
                }
            }
            return this.character;
        }
        throw this.unexpectedEndOfStreamException();
    }

    private int next() throws IOException {
        this.character = this.reader.read();
        if (this.character != -1) {
            this.col.incrementAndGet();
            if (this.character == 10) {
                this.row.incrementAndGet();
                this.col.set(-1L);
            } else if (this.character == 9) {
                this.col.addAndGet(3L);
            }
            return this.character;
        }
        throw this.unexpectedEndOfStreamException();
    }

    private JsonSyntaxException unexpectedCharacterException() {
        String c = new String(Character.toChars(this.character));
        throw new JsonSyntaxException(this.row, this.col, "Unexpected character '" + c + "' (Unicode: " + this.codePoints(c) + ")");
    }

    private JsonSyntaxException duplicateKeyException(String key) {
        throw new JsonSyntaxException(this.row, this.col, "Duplicate key '" + key + "'");
    }

    private JsonSyntaxException unexpectedEndOfStreamException() {
        throw new JsonSyntaxException(this.row, this.col, "Unexpected end of stream");
    }

    private void putIfUniqueOrThrow(Map<String, Object> object, String key, Object value) {
        if (object.put(key, value) != null) {
            throw this.duplicateKeyException(key);
        }
    }

    private String codePoints(String c) {
        StringJoiner str = new StringJoiner(" ");
        for (int i = 0; i < c.length(); ++i) {
            str.add(String.valueOf(Character.codePointAt(c, i)));
        }
        return str.toString();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            throw new JsonException("Failed to safely close stream.", ex);
        }
    }

    private static enum CloseMethod {
        EXIT_FROM_PARENT,
        CONTINUE_IN_PARENT,
        NOT_DECIDED;

    }
}

