/*
 *
 * Copyright (c) 2006-2020, Speedment, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); You may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.speedment.common.tuple;

import com.speedment.common.tuple.internal.mutable.*;
import com.speedment.common.tuple.mutable.MutableTuple0;
import com.speedment.common.tuple.mutable.MutableTuple10;
import com.speedment.common.tuple.mutable.MutableTuple11;
import com.speedment.common.tuple.mutable.MutableTuple12;
import com.speedment.common.tuple.mutable.MutableTuple13;
import com.speedment.common.tuple.mutable.MutableTuple14;
import com.speedment.common.tuple.mutable.MutableTuple15;
import com.speedment.common.tuple.mutable.MutableTuple16;
import com.speedment.common.tuple.mutable.MutableTuple17;
import com.speedment.common.tuple.mutable.MutableTuple18;
import com.speedment.common.tuple.mutable.MutableTuple19;
import com.speedment.common.tuple.mutable.MutableTuple1;
import com.speedment.common.tuple.mutable.MutableTuple20;
import com.speedment.common.tuple.mutable.MutableTuple21;
import com.speedment.common.tuple.mutable.MutableTuple22;
import com.speedment.common.tuple.mutable.MutableTuple23;
import com.speedment.common.tuple.mutable.MutableTuple2;
import com.speedment.common.tuple.mutable.MutableTuple3;
import com.speedment.common.tuple.mutable.MutableTuple4;
import com.speedment.common.tuple.mutable.MutableTuple5;
import com.speedment.common.tuple.mutable.MutableTuple6;
import com.speedment.common.tuple.mutable.MutableTuple7;
import com.speedment.common.tuple.mutable.MutableTuple8;
import com.speedment.common.tuple.mutable.MutableTuple9;

import java.util.function.Supplier;

/**
 * A collection of static methods to produce different types of {@link
 * MutableTuple} objects
 * <p>
 * Generated by com.speedment.sources.pattern.tuple.MutableTuplesPattern
 * 
 * @author Per Minborg
 */
public final class MutableTuples {
    
    private MutableTuples() {}
    
    /**
     * Creates and returns a new {@link MutableTuple0} constructor that creates
     * an object that is empty.
     * 
     * @return a new {@link MutableTuple0} constructor that creates an object
     *         that is empty.
     * 
     * @see Tuple0
     * @see Tuple
     */
    public static Supplier<MutableTuple0> constructor() {
        return () -> MutableTuple0Impl.EMPTY_TUPLE;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple0}  that is empty.
     * 
     * @return a new {@link MutableTuple0}  that is empty.
     * 
     * @see Tuple0
     * @see Tuple
     */
    public static MutableTuple0 create0() {
        return MutableTuple0Impl.EMPTY_TUPLE;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple1} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param e0   element 0
     * @return     a new {@link MutableTuple1} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple1
     * @see Tuple
     */
    public static <T0> Supplier<MutableTuple1<T0>> constructor(Class<T0> e0) {
        return MutableTuple1Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple1}  that is empty.
     * 
     * @param <T0> type of element 0
     * @return     a new {@link MutableTuple1}  that is empty.
     * 
     * @see Tuple1
     * @see Tuple
     */
    public static <T0> MutableTuple1<T0> create1() {
        return new MutableTuple1Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple2} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param e0   element 0
     * @param e1   element 1
     * @return     a new {@link MutableTuple2} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple2
     * @see Tuple
     */
    public static <T0, T1> Supplier<MutableTuple2<T0, T1>> constructor(Class<T0> e0, Class<T1> e1) {
        return MutableTuple2Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple2}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @return     a new {@link MutableTuple2}  that is empty.
     * 
     * @see Tuple2
     * @see Tuple
     */
    public static <T0, T1> MutableTuple2<T0, T1> create2() {
        return new MutableTuple2Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple3} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @return     a new {@link MutableTuple3} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple3
     * @see Tuple
     */
    public static <T0, T1, T2> Supplier<MutableTuple3<T0, T1, T2>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2) {
        return MutableTuple3Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple3}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @return     a new {@link MutableTuple3}  that is empty.
     * 
     * @see Tuple3
     * @see Tuple
     */
    public static <T0, T1, T2> MutableTuple3<T0, T1, T2> create3() {
        return new MutableTuple3Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple4} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @return     a new {@link MutableTuple4} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple4
     * @see Tuple
     */
    public static <T0, T1, T2, T3> Supplier<MutableTuple4<T0, T1, T2, T3>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3) {
        return MutableTuple4Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple4}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @return     a new {@link MutableTuple4}  that is empty.
     * 
     * @see Tuple4
     * @see Tuple
     */
    public static <T0, T1, T2, T3> MutableTuple4<T0, T1, T2, T3> create4() {
        return new MutableTuple4Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple5} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @return     a new {@link MutableTuple5} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple5
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4> Supplier<MutableTuple5<T0, T1, T2, T3, T4>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4) {
        return MutableTuple5Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple5}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @return     a new {@link MutableTuple5}  that is empty.
     * 
     * @see Tuple5
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4> MutableTuple5<T0, T1, T2, T3, T4> create5() {
        return new MutableTuple5Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple6} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @return     a new {@link MutableTuple6} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple6
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5> Supplier<MutableTuple6<T0, T1, T2, T3, T4, T5>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5) {
        return MutableTuple6Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple6}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @return     a new {@link MutableTuple6}  that is empty.
     * 
     * @see Tuple6
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5> MutableTuple6<T0, T1, T2, T3, T4, T5> create6() {
        return new MutableTuple6Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple7} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @return     a new {@link MutableTuple7} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple7
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6> Supplier<MutableTuple7<T0, T1, T2, T3, T4, T5, T6>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6) {
        return MutableTuple7Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple7}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @return     a new {@link MutableTuple7}  that is empty.
     * 
     * @see Tuple7
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6> MutableTuple7<T0, T1, T2, T3, T4, T5, T6> create7() {
        return new MutableTuple7Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple8} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @param e7   element 7
     * @return     a new {@link MutableTuple8} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple8
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7> Supplier<MutableTuple8<T0, T1, T2, T3, T4, T5, T6, T7>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7) {
        return MutableTuple8Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple8}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @return     a new {@link MutableTuple8}  that is empty.
     * 
     * @see Tuple8
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7> MutableTuple8<T0, T1, T2, T3, T4, T5, T6, T7> create8() {
        return new MutableTuple8Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple9} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param <T8> type of element 8
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @param e7   element 7
     * @param e8   element 8
     * @return     a new {@link MutableTuple9} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple9
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8> Supplier<MutableTuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8) {
        return MutableTuple9Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple9}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param <T8> type of element 8
     * @return     a new {@link MutableTuple9}  that is empty.
     * 
     * @see Tuple9
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8> MutableTuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8> create9() {
        return new MutableTuple9Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple10} constructor that creates
     * an object that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param <T8> type of element 8
     * @param <T9> type of element 9
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @param e7   element 7
     * @param e8   element 8
     * @param e9   element 9
     * @return     a new {@link MutableTuple10} constructor that creates an
     *             object that is empty.
     * 
     * @see Tuple10
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> Supplier<MutableTuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9) {
        return MutableTuple10Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple10}  that is empty.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param <T8> type of element 8
     * @param <T9> type of element 9
     * @return     a new {@link MutableTuple10}  that is empty.
     * 
     * @see Tuple10
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> MutableTuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> create10() {
        return new MutableTuple10Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple11} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @return      a new {@link MutableTuple11} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple11
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Supplier<MutableTuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10) {
        return MutableTuple11Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple11}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @return      a new {@link MutableTuple11}  that is empty.
     * 
     * @see Tuple11
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> MutableTuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> create11() {
        return new MutableTuple11Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple12} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @return      a new {@link MutableTuple12} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple12
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Supplier<MutableTuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11) {
        return MutableTuple12Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple12}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @return      a new {@link MutableTuple12}  that is empty.
     * 
     * @see Tuple12
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> MutableTuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> create12() {
        return new MutableTuple12Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple13} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @return      a new {@link MutableTuple13} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple13
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Supplier<MutableTuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12) {
        return MutableTuple13Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple13}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @return      a new {@link MutableTuple13}  that is empty.
     * 
     * @see Tuple13
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> MutableTuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> create13() {
        return new MutableTuple13Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple14} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @return      a new {@link MutableTuple14} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple14
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Supplier<MutableTuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13) {
        return MutableTuple14Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple14}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @return      a new {@link MutableTuple14}  that is empty.
     * 
     * @see Tuple14
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> MutableTuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> create14() {
        return new MutableTuple14Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple15} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @return      a new {@link MutableTuple15} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple15
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Supplier<MutableTuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14) {
        return MutableTuple15Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple15}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @return      a new {@link MutableTuple15}  that is empty.
     * 
     * @see Tuple15
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> MutableTuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> create15() {
        return new MutableTuple15Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple16} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @return      a new {@link MutableTuple16} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple16
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Supplier<MutableTuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15) {
        return MutableTuple16Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple16}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @return      a new {@link MutableTuple16}  that is empty.
     * 
     * @see Tuple16
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> MutableTuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> create16() {
        return new MutableTuple16Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple17} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @return      a new {@link MutableTuple17} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple17
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Supplier<MutableTuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15,
            Class<T16> e16) {
        return MutableTuple17Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple17}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @return      a new {@link MutableTuple17}  that is empty.
     * 
     * @see Tuple17
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> MutableTuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> create17() {
        return new MutableTuple17Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple18} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @return      a new {@link MutableTuple18} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple18
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> Supplier<MutableTuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15,
            Class<T16> e16,
            Class<T17> e17) {
        return MutableTuple18Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple18}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @return      a new {@link MutableTuple18}  that is empty.
     * 
     * @see Tuple18
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> MutableTuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> create18() {
        return new MutableTuple18Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple19} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @return      a new {@link MutableTuple19} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple19
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> Supplier<MutableTuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15,
            Class<T16> e16,
            Class<T17> e17,
            Class<T18> e18) {
        return MutableTuple19Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple19}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @return      a new {@link MutableTuple19}  that is empty.
     * 
     * @see Tuple19
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> MutableTuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> create19() {
        return new MutableTuple19Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple20} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @return      a new {@link MutableTuple20} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple20
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> Supplier<MutableTuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15,
            Class<T16> e16,
            Class<T17> e17,
            Class<T18> e18,
            Class<T19> e19) {
        return MutableTuple20Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple20}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @return      a new {@link MutableTuple20}  that is empty.
     * 
     * @see Tuple20
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> MutableTuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> create20() {
        return new MutableTuple20Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple21} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @param e20   element 20
     * @return      a new {@link MutableTuple21} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple21
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> Supplier<MutableTuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15,
            Class<T16> e16,
            Class<T17> e17,
            Class<T18> e18,
            Class<T19> e19,
            Class<T20> e20) {
        return MutableTuple21Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple21}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @return      a new {@link MutableTuple21}  that is empty.
     * 
     * @see Tuple21
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> MutableTuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> create21() {
        return new MutableTuple21Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple22} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param <T21> type of element 21
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @param e20   element 20
     * @param e21   element 21
     * @return      a new {@link MutableTuple22} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple22
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> Supplier<MutableTuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15,
            Class<T16> e16,
            Class<T17> e17,
            Class<T18> e18,
            Class<T19> e19,
            Class<T20> e20,
            Class<T21> e21) {
        return MutableTuple22Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple22}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param <T21> type of element 21
     * @return      a new {@link MutableTuple22}  that is empty.
     * 
     * @see Tuple22
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> MutableTuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> create22() {
        return new MutableTuple22Impl<>();
    }
    
    /**
     * Creates and returns a new {@link MutableTuple23} constructor that creates
     * an object that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param <T21> type of element 21
     * @param <T22> type of element 22
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @param e20   element 20
     * @param e21   element 21
     * @param e22   element 22
     * @return      a new {@link MutableTuple23} constructor that creates an
     *              object that is empty.
     * 
     * @see Tuple23
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> Supplier<MutableTuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> constructor(
            Class<T0> e0,
            Class<T1> e1,
            Class<T2> e2,
            Class<T3> e3,
            Class<T4> e4,
            Class<T5> e5,
            Class<T6> e6,
            Class<T7> e7,
            Class<T8> e8,
            Class<T9> e9,
            Class<T10> e10,
            Class<T11> e11,
            Class<T12> e12,
            Class<T13> e13,
            Class<T14> e14,
            Class<T15> e15,
            Class<T16> e16,
            Class<T17> e17,
            Class<T18> e18,
            Class<T19> e19,
            Class<T20> e20,
            Class<T21> e21,
            Class<T22> e22) {
        return MutableTuple23Impl::new;
    }
    
    /**
     * Creates and returns a new {@link MutableTuple23}  that is empty.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param <T21> type of element 21
     * @param <T22> type of element 22
     * @return      a new {@link MutableTuple23}  that is empty.
     * 
     * @see Tuple23
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> MutableTuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> create23() {
        return new MutableTuple23Impl<>();
    }
}