/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.analytics.standard.internal.google;

import com.speedment.common.rest.Option;
import com.speedment.common.rest.Param;
import com.speedment.common.rest.Rest;
import com.speedment.jpastreamer.analytics.standard.internal.Handler;
import com.speedment.jpastreamer.analytics.standard.internal.google.EventType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Stream;

public final class GoogleAnalyticsHandler
implements Handler {
    private static final String COOKIE_FILE_NAME = "JPAstreamer.clientid";
    private static final String URL_STRING = "www.google-analytics.com";
    private static final String TRACKING_ID = "UA-54384165-3";
    private final String version;
    private final boolean demoMode;
    private final String clientId;
    private final Random random;
    private final Rest analytics;

    public GoogleAnalyticsHandler(String version, boolean demoMode) {
        this.version = Objects.requireNonNull(version);
        this.demoMode = demoMode;
        this.clientId = this.acquireClientId();
        this.random = new SecureRandom();
        this.analytics = Rest.connectHttps((String)URL_STRING);
    }

    @Override
    public void starting() {
        this.report(EventType.STARTED);
    }

    @Override
    public void running() {
        this.report(EventType.ALIVE);
    }

    @Override
    public void stopping() {
        this.report(EventType.STOPPED);
    }

    private void report(EventType eventType) {
        Objects.requireNonNull(eventType);
        String eventName = eventType.eventName() + (this.demoMode ? "-demo" : "");
        StringJoiner payload = new StringJoiner("&").add("v=" + Rest.encode((String)"1")).add("ds=" + Rest.encode((String)"speedment")).add("tid=" + Rest.encode((String)TRACKING_ID)).add("cid=" + this.clientId).add("t=" + Rest.encode((String)"screenview")).add("ni=" + Rest.encode((String)"1")).add("cd=" + Rest.encode((String)eventName)).add("an=" + Rest.encode((String)"jpastreamer")).add("av=" + Rest.encode((String)this.version));
        eventType.sessionControl().ifPresent(sc -> payload.add("sc=" + sc));
        this.analytics.post("collect", payload.toString(), new Option[]{Param.param((String)"z", (String)Integer.toString(this.random.nextInt()))}).handle((res, ex) -> {
            if (ex != null) {
                System.err.println("Exception while sending usage statistics to Google Analytics.");
                ex.printStackTrace();
            } else if (!res.success()) {
                System.err.println("Exception while sending usage statistics to Google Analytics.");
                System.err.println(String.format("Google Analytics returned %d: %s", res.getStatus(), res.getText()));
            }
            return res;
        });
    }

    private String acquireClientId() {
        String string;
        block10: {
            String userHome = System.getProperty("user.home");
            Path path2 = Paths.get(userHome, COOKIE_FILE_NAME);
            Stream<String> lines = Files.lines(path2, StandardCharsets.UTF_8);
            try {
                string = lines.findFirst().map(UUID::fromString).orElseThrow(NoSuchElementException::new).toString();
                if (lines == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception path2) {
                    String clientId = UUID.randomUUID().toString();
                    try {
                        Path path3 = Paths.get(userHome, COOKIE_FILE_NAME);
                        Files.write(path3, clientId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return clientId;
                }
            }
            lines.close();
        }
        return string;
    }
}

