/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.application.standard.internal;

import com.speedment.jpastreamer.analytics.AnalyticsReporter;
import com.speedment.jpastreamer.analytics.AnalyticsReporterFactory;
import com.speedment.jpastreamer.announcer.Announcer;
import com.speedment.jpastreamer.appinfo.ApplicationInformation;
import com.speedment.jpastreamer.application.JPAStreamer;
import com.speedment.jpastreamer.application.standard.internal.StandardStreamer;
import com.speedment.jpastreamer.application.standard.internal.Streamer;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import jakarta.persistence.EntityManager;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class StandardJPAStreamer
implements JPAStreamer {
    private final Supplier<EntityManager> entityManagerSupplier;
    private final Runnable closeHandler;
    private final Map<StreamConfiguration<?>, Streamer<?>> streamerCache;
    private final AnalyticsReporter analyticsReporter;
    private final boolean closeEntityManagers;

    StandardJPAStreamer(Supplier<EntityManager> entityManagerSupplier, Runnable closeHandler, boolean demoMode, boolean closeEntityManagers) {
        this.closeHandler = Objects.requireNonNull(closeHandler);
        this.entityManagerSupplier = Objects.requireNonNull(entityManagerSupplier);
        this.closeEntityManagers = closeEntityManagers;
        this.streamerCache = new ConcurrentHashMap();
        ApplicationInformation applicationInformation = (ApplicationInformation)RootFactory.getOrThrow(ApplicationInformation.class, ServiceLoader::load);
        AnalyticsReporterFactory analyticsReporterFactory = (AnalyticsReporterFactory)RootFactory.getOrThrow(AnalyticsReporterFactory.class, ServiceLoader::load);
        this.analyticsReporter = analyticsReporterFactory.createAnalyticsReporter(applicationInformation.implementationVersion(), demoMode);
        this.analyticsReporter.start();
        this.printGreeting(applicationInformation);
    }

    public <T> Stream<T> stream(StreamConfiguration<T> streamConfiguration) {
        Objects.requireNonNull(streamConfiguration);
        if (streamConfiguration.joins().isEmpty()) {
            return this.streamerCache.computeIfAbsent(streamConfiguration, ec -> new StandardStreamer(streamConfiguration, this.entityManagerSupplier)).stream();
        }
        StandardStreamer<T> streamer = new StandardStreamer<T>(streamConfiguration, this.entityManagerSupplier);
        return this.closeEntityManagers ? (Stream)streamer.stream().onClose(streamer::close) : streamer.stream();
    }

    public void resetStreamer(Class<?> ... entityClasses) throws UnsupportedOperationException {
        if (!this.closeEntityManagers) {
            throw new UnsupportedOperationException("An instance of JPAStreamer.of(Supplier<EntityManager>) is not responsible for the lifecycle of the supplied Entity Managers, and thus cannot reset the Entity Managers.");
        }
        Arrays.stream(entityClasses).map(StreamConfiguration::of).forEach(this.streamerCache::remove);
    }

    public void close() {
        this.streamerCache.values().forEach(Streamer::close);
        this.analyticsReporter.stop();
        this.closeHandler.run();
    }

    private void printGreeting(ApplicationInformation info) {
        String greeting = String.format("%s%n:: %s %s :: %s%nCopyright %s%nLicensed under %s%nRunning under %s %s", info.banner(), info.title(), info.subtitle(), info.implementationVersion(), info.vendor(), info.licenseName(), System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"));
        System.out.println(greeting);
        RootFactory.stream(Announcer.class, ServiceLoader::load).map(Announcer::greeting).filter(Objects::nonNull).filter(s -> !s.isEmpty()).forEach(System.out::println);
        if (!info.isProductionMode()) {
            System.out.println("This version is NOT INTENDED FOR PRODUCTION USE!");
            System.out.println("View known bugs at https://github.com/speedment/jpa-streamer/issues?q=is%3Aissue+is%3Aopen+label%3Abug");
        }
    }
}

