/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.autoclose.standard.internal;

import com.speedment.jpastreamer.autoclose.standard.internal.AutoClosingDoubleStream;
import com.speedment.jpastreamer.autoclose.standard.internal.AutoClosingIntStream;
import com.speedment.jpastreamer.autoclose.standard.internal.AutoClosingLongStream;
import com.speedment.jpastreamer.autoclose.standard.internal.AutoClosingStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

abstract class AbstractAutoClosingBaseStream<T, S extends BaseStream<T, S>>
implements AutoCloseable {
    private final S stream;
    private final boolean allowStreamIteratorAndSpliterator;
    private final AtomicBoolean closed;

    AbstractAutoClosingBaseStream(S stream, boolean allowStreamIteratorAndSpliterator) {
        this.stream = (BaseStream)Objects.requireNonNull(stream);
        this.allowStreamIteratorAndSpliterator = allowStreamIteratorAndSpliterator;
        this.closed = new AtomicBoolean();
    }

    protected S stream() {
        return this.stream;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.stream().close();
        }
    }

    boolean isAllowStreamIteratorAndSpliterator() {
        return this.allowStreamIteratorAndSpliterator;
    }

    boolean finallyClose(BooleanSupplier bs) {
        try {
            boolean bl = bs.getAsBoolean();
            return bl;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long finallyClose(LongSupplier lp) {
        try {
            long l = lp.getAsLong();
            return l;
        }
        finally {
            this.close();
        }
    }

    int finallyClose(IntSupplier is) {
        try {
            int n = is.getAsInt();
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double finallyClose(DoubleSupplier ds) {
        try {
            double d = ds.getAsDouble();
            return d;
        }
        finally {
            this.close();
        }
    }

    void finallyClose(Runnable r) {
        try {
            r.run();
        }
        finally {
            this.close();
        }
    }

    <U> U finallyClose(Supplier<U> s) {
        try {
            U u = s.get();
            return u;
        }
        finally {
            this.close();
        }
    }

    <U> Stream<U> wrap(Stream<U> stream) {
        return this.wrap(stream, AutoClosingStream::new);
    }

    IntStream wrap(IntStream stream) {
        return this.wrap(stream, AutoClosingIntStream::new);
    }

    LongStream wrap(LongStream stream) {
        return this.wrap(stream, AutoClosingLongStream::new);
    }

    DoubleStream wrap(DoubleStream stream) {
        return this.wrap(stream, AutoClosingDoubleStream::new);
    }

    private <U> U wrap(U stream, BiFunction<U, Boolean, U> wrapper) {
        if (stream instanceof AbstractAutoClosingBaseStream) {
            return stream;
        }
        return wrapper.apply((Boolean)stream, this.allowStreamIteratorAndSpliterator);
    }

    static UnsupportedOperationException newUnsupportedException(String methodName) {
        return new UnsupportedOperationException("The " + methodName + "() method is unsupported because otherwise the AutoClose property cannot be guaranteed");
    }
}

