/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.builder.standard.internal;

import com.speedment.jpastreamer.pipeline.Pipeline;
import com.speedment.jpastreamer.renderer.RenderResult;
import com.speedment.jpastreamer.renderer.Renderer;
import com.speedment.jpastreamer.renderer.RendererFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public final class MockRendererFactory
implements RendererFactory {
    private final BiConsumer<Pipeline<?>, RenderResult<?, ?, ?>> listener;

    public MockRendererFactory(BiConsumer<Pipeline<?>, RenderResult<?, ?, ?>> listener) {
        this.listener = listener;
    }

    public Renderer createRenderer(EntityManagerFactory entityManagerFactory) {
        return new MockRenderer();
    }

    public Renderer createRenderer(Supplier<EntityManager> entityManagerSupplier) {
        return new MockRenderer();
    }

    public Renderer createRenderer(EntityManager entityManager) {
        return new MockRenderer();
    }

    private final class MockRenderer
    implements Renderer {
        private MockRenderer() {
        }

        public <E, T, S extends BaseStream<T, S>> RenderResult<E, T, S> render(Pipeline<E> pipeline, StreamConfiguration<E> streamConfiguration) {
            Object renderResult = null;
            MockRendererFactory.this.listener.accept(pipeline, renderResult);
            return null;
        }

        public void close() {
        }
    }
}

