/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.builder.standard.internal;

import com.speedment.jpastreamer.builder.standard.internal.BaseBuilderState;
import com.speedment.jpastreamer.builder.standard.internal.BaseStreamBuilder;
import com.speedment.jpastreamer.builder.standard.internal.DoubleStreamBuilder;
import com.speedment.jpastreamer.builder.standard.internal.IntStreamBuilder;
import com.speedment.jpastreamer.builder.standard.internal.LongStreamBuilder;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationFactory;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

final class StreamBuilder<E, T>
extends BaseStreamBuilder<E, T, Stream<T>>
implements Stream<T> {
    StreamBuilder(BaseBuilderState<E> baseState) {
        super(baseState);
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        this.add(this.iof().createFilter(predicate));
        return this;
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        this.add(this.iof().createMap(mapper));
        return this;
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        this.add(this.iof().createMapToInt(mapper));
        this.linked();
        return new IntStreamBuilder(this.baseState());
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        this.add(this.iof().createMapToLong(mapper));
        this.linked();
        return new LongStreamBuilder(this.baseState());
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        this.add(this.iof().createMapToDouble(mapper));
        this.linked();
        return new DoubleStreamBuilder(this.baseState());
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        this.add(this.iof().createFlatMap(mapper));
        return this;
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        this.add(this.iof().createFlatMapToInt(mapper));
        this.linked();
        return new IntStreamBuilder(this.baseState());
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        this.add(this.iof().createFlatMapToLong(mapper));
        this.linked();
        return new LongStreamBuilder(this.baseState());
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        this.add(this.iof().createFlatMapToDouble(mapper));
        this.linked();
        return new DoubleStreamBuilder(this.baseState());
    }

    @Override
    public Stream<T> distinct() {
        this.add(this.iof().acquireDistinct());
        return this;
    }

    @Override
    public Stream<T> sorted() {
        this.add(this.iof().acquireSorted());
        return this;
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        this.add(this.iof().createSorted(comparator));
        return this;
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        this.add(this.iof().createPeek(action));
        return this;
    }

    @Override
    public Stream<T> limit(long maxSize) {
        this.add(this.iof().createLimit(maxSize));
        return this;
    }

    @Override
    public Stream<T> skip(long n) {
        this.add(this.iof().createSkip(n));
        return this;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.set(this.tof().createForEach(action));
        this.renderAndThenAccept();
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.set(this.tof().createForEachOrdered(action));
        this.renderAndThenAccept();
    }

    @Override
    public Object[] toArray() {
        this.set(this.tof().acquireToArray());
        return (Object[])this.renderAndThenApply();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        this.set(this.tof().createToArray(generator));
        return (Object[])this.renderAndThenApply();
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        this.set(this.tof().createReduce(identity, accumulator));
        return (T)this.renderAndThenApply();
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        this.set(this.tof().createReduce(accumulator));
        return (Optional)this.renderAndThenApply();
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        this.set(this.tof().createReduce(identity, accumulator, combiner));
        return (U)this.renderAndThenApply();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        this.set(this.tof().createCollect(supplier, accumulator, combiner));
        return this.renderAndThenApply();
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        this.set(this.tof().createCollect(collector));
        return this.renderAndThenApply();
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        this.set(this.tof().createMin(comparator));
        return (Optional)this.renderAndThenApply();
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        this.set(this.tof().createMax(comparator));
        return (Optional)this.renderAndThenApply();
    }

    @Override
    public long count() {
        this.set(this.tof().acquireCount());
        return this.renderCount();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        this.set(this.tof().createAnyMatch(predicate));
        return this.renderAndThenTest();
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        this.set(this.tof().createAllMatch(predicate));
        return this.renderAndThenTest();
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        this.set(this.tof().createNoneMatch(predicate));
        return this.renderAndThenTest();
    }

    @Override
    public Optional<T> findFirst() {
        this.set(this.tof().acquireFindFirst());
        return (Optional)this.renderAndThenApply();
    }

    @Override
    public Optional<T> findAny() {
        this.set(this.tof().acquireFindAny());
        return (Optional)this.renderAndThenApply();
    }

    @Override
    public Iterator<T> iterator() {
        this.set(this.tof().acquireIterator());
        return (Iterator)this.renderAndThenApply();
    }

    @Override
    public Spliterator<T> spliterator() {
        this.set(this.tof().acquireSpliterator());
        return (Spliterator)this.renderAndThenApply();
    }

    private IntermediateOperationFactory iof() {
        return this.baseState().factories().intermediate();
    }

    private TerminalOperationFactory tof() {
        return this.baseState().factories().terminal();
    }
}

