/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.criteria.standard.internal.predicate;

import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ParameterizedPredicate<K, S> {
    private final BiFunction<K, ParameterExpression<S>, Predicate> parameterMapper;
    private final Function<S, S> valueMapper;

    private ParameterizedPredicate(BiFunction<K, ParameterExpression<S>, Predicate> parameterMapper) {
        this(parameterMapper, Function.identity());
    }

    private ParameterizedPredicate(BiFunction<K, ParameterExpression<S>, Predicate> parameterMapper, Function<S, S> valueMapper) {
        this.parameterMapper = Objects.requireNonNull(parameterMapper);
        this.valueMapper = Objects.requireNonNull(valueMapper);
    }

    public BiFunction<K, ParameterExpression<S>, Predicate> getParameterMapper() {
        return this.parameterMapper;
    }

    public Function<S, S> getValueMapper() {
        return this.valueMapper;
    }

    public static <K, S> ParameterizedPredicate<K, S> createParameterizedPredicate(BiFunction<K, ParameterExpression<S>, Predicate> parameterMapper) {
        return new ParameterizedPredicate<K, S>(parameterMapper);
    }

    public static <K, S> ParameterizedPredicate<K, S> createParameterizedPredicate(BiFunction<K, ParameterExpression<S>, Predicate> parameterMapper, Function<S, S> valueMapper) {
        return new ParameterizedPredicate<K, S>(parameterMapper, valueMapper);
    }
}

