/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.criteria.standard.internal.predicate;

import com.speedment.common.function.TriFunction;
import com.speedment.jpastreamer.criteria.Criteria;
import com.speedment.jpastreamer.criteria.QueryParameter;
import com.speedment.jpastreamer.criteria.standard.internal.InternalQueryParameter;
import com.speedment.jpastreamer.criteria.standard.internal.predicate.ParameterizedPredicate;
import com.speedment.jpastreamer.criteria.standard.internal.predicate.PredicateMapper;
import com.speedment.jpastreamer.criteria.standard.internal.predicate.PredicateMapping;
import com.speedment.jpastreamer.criteria.standard.internal.util.Cast;
import com.speedment.jpastreamer.exception.JPAStreamerException;
import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.trait.HasInclusion;
import com.speedment.jpastreamer.field.trait.HasArg0;
import com.speedment.jpastreamer.field.trait.HasArg1;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class DefaultPredicateMapper
implements PredicateMapper {
    @Override
    public <ENTITY> PredicateMapping mapPredicate(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        Objects.requireNonNull(criteria);
        Objects.requireNonNull(fieldPredicate);
        return this.mapPredicate0(criteria, fieldPredicate);
    }

    private <ENTITY> PredicateMapping alwaysTrue(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.noValueMapping(fieldPredicate, column -> criteria.getBuilder().isTrue(criteria.getBuilder().literal((Object)true)));
    }

    private <ENTITY> PredicateMapping alwaysFalse(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.noValueMapping(fieldPredicate, column -> criteria.getBuilder().isFalse(criteria.getBuilder().literal((Object)true)));
    }

    private <ENTITY> PredicateMapping isNull(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.noValueMapping(fieldPredicate, column -> criteria.getBuilder().isNull((Expression)criteria.getRoot().get(column)));
    }

    private <ENTITY> PredicateMapping isNotNull(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.noValueMapping(fieldPredicate, column -> criteria.getBuilder().isNotNull((Expression)criteria.getRoot().get(column)));
    }

    private <ENTITY> PredicateMapping equal(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().equal((Expression)criteria.getRoot().get(column), (Expression)parameter)), Object.class);
    }

    private <ENTITY> PredicateMapping notEqual(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notEqual((Expression)criteria.getRoot().get(column), (Expression)parameter)), Object.class);
    }

    private <ENTITY> PredicateMapping lessThan(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.singleBoundRangeComparisonMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().lt((Expression)criteria.getRoot().get(column), (Expression)parameter)), ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().lessThan((Expression)criteria.getRoot().get(column), (Expression)parameter)));
    }

    private <ENTITY> PredicateMapping lessOrEqual(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.singleBoundRangeComparisonMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().le((Expression)criteria.getRoot().get(column), (Expression)parameter)), ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().lessThanOrEqualTo((Expression)criteria.getRoot().get(column), (Expression)parameter)));
    }

    private <ENTITY, S extends Comparable<? super S>> PredicateMapping between(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.doubleBoundRangeComparisonMapping(criteria, fieldPredicate, (column, parameterExpressions, inclusion) -> {
            CriteriaBuilder builder = criteria.getBuilder();
            Path columnPath = criteria.getRoot().get(column);
            ParameterExpression first = (ParameterExpression)parameterExpressions.getFirst();
            ParameterExpression second = (ParameterExpression)parameterExpressions.getSecond();
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return builder.and((Expression)builder.greaterThan((Expression)columnPath, (Expression)first), (Expression)builder.lessThan((Expression)columnPath, (Expression)second));
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return builder.and((Expression)builder.greaterThanOrEqualTo((Expression)columnPath, (Expression)first), (Expression)builder.lessThan((Expression)columnPath, (Expression)second));
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return builder.and((Expression)builder.greaterThan((Expression)columnPath, (Expression)first), (Expression)builder.lessThanOrEqualTo((Expression)columnPath, (Expression)second));
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return builder.between((Expression)columnPath, (Expression)first, (Expression)second);
                }
            }
            throw new JPAStreamerException("Inclusion type [" + String.valueOf(inclusion) + "] is not supported");
        });
    }

    private <ENTITY, S extends Comparable<? super S>> PredicateMapping notBetween(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.doubleBoundRangeComparisonMapping(criteria, fieldPredicate, (column, parameterExpressions, inclusion) -> {
            CriteriaBuilder builder = criteria.getBuilder();
            Path columnPath = criteria.getRoot().get(column);
            ParameterExpression first = (ParameterExpression)parameterExpressions.getFirst();
            ParameterExpression second = (ParameterExpression)parameterExpressions.getSecond();
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return builder.or((Expression)builder.lessThanOrEqualTo((Expression)columnPath, (Expression)first), (Expression)builder.greaterThanOrEqualTo((Expression)columnPath, (Expression)second));
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return builder.or((Expression)builder.lessThanOrEqualTo((Expression)columnPath, (Expression)first), (Expression)builder.greaterThan((Expression)columnPath, (Expression)second));
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return builder.or((Expression)builder.lessThan((Expression)columnPath, (Expression)first), (Expression)builder.greaterThan((Expression)columnPath, (Expression)second));
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return builder.or((Expression)builder.lessThan((Expression)columnPath, (Expression)first), (Expression)builder.greaterThanOrEqualTo((Expression)columnPath, (Expression)second));
                }
            }
            throw new JPAStreamerException("Inclusion type [" + String.valueOf(inclusion) + "] is not supported");
        });
    }

    private <ENTITY> PredicateMapping in(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        Object value = Cast.castOrFail(fieldPredicate, HasArg0.class).get0();
        if (!(value instanceof Set)) {
            throw new JPAStreamerException();
        }
        Field field = fieldPredicate.getField();
        String column = field.columnName();
        Set set = (Set)value;
        return new PredicateMapping(criteria.getRoot().get(column).in((Collection)set), new QueryParameter[0]);
    }

    private <ENTITY> PredicateMapping notIn(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        Predicate predicate = this.in(criteria, fieldPredicate).getPredicate().not();
        return new PredicateMapping(predicate, new QueryParameter[0]);
    }

    private <ENTITY> PredicateMapping greaterThan(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.singleBoundRangeComparisonMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().gt((Expression)criteria.getRoot().get(column), (Expression)parameter)), ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().greaterThan((Expression)criteria.getRoot().get(column), (Expression)parameter)));
    }

    private <ENTITY> PredicateMapping greaterOrEqual(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.singleBoundRangeComparisonMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().ge((Expression)criteria.getRoot().get(column), (Expression)parameter)), ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().greaterThanOrEqualTo((Expression)criteria.getRoot().get(column), (Expression)parameter)));
    }

    private <ENTITY> PredicateMapping equalIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().equal(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), String::toLowerCase), String.class);
    }

    private <ENTITY> PredicateMapping notEqualIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notEqual(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), String::toLowerCase), String.class);
    }

    private <ENTITY> PredicateMapping startsWith(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().like((Expression)criteria.getRoot().get(column), (Expression)parameter), value -> value + "%"), String.class);
    }

    private <ENTITY> PredicateMapping notStartsWith(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notLike((Expression)criteria.getRoot().get(column), (Expression)parameter), value -> value + "%"), String.class);
    }

    private <ENTITY> PredicateMapping startsWithIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().like(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), value -> value.toLowerCase() + "%"), String.class);
    }

    private <ENTITY> PredicateMapping notStartsWithIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notLike(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), value -> value.toLowerCase() + "%"), String.class);
    }

    private <ENTITY> PredicateMapping endsWith(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().like((Expression)criteria.getRoot().get(column), (Expression)parameter), value -> "%" + value), String.class);
    }

    private <ENTITY> PredicateMapping notEndsWith(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notLike((Expression)criteria.getRoot().get(column), (Expression)parameter), value -> "%" + value), String.class);
    }

    private <ENTITY> PredicateMapping endsWithIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().like(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), value -> "%" + value.toLowerCase()), String.class);
    }

    private <ENTITY> PredicateMapping notEndsWithIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notLike(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), value -> "%" + value.toLowerCase()), String.class);
    }

    private <ENTITY> PredicateMapping contains(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().like((Expression)criteria.getRoot().get(column), (Expression)parameter), value -> "%" + value + "%"), String.class);
    }

    private <ENTITY> PredicateMapping notContains(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notLike((Expression)criteria.getRoot().get(column), (Expression)parameter), value -> "%" + value + "%"), String.class);
    }

    private <ENTITY> PredicateMapping containsIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().like(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), value -> "%" + value.toLowerCase() + "%"), String.class);
    }

    private <ENTITY> PredicateMapping notContainsIgnoreCase(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.typeMapping(criteria, fieldPredicate, ParameterizedPredicate.createParameterizedPredicate((column, parameter) -> criteria.getBuilder().notLike(criteria.getBuilder().lower((Expression)criteria.getRoot().get(column)), (Expression)parameter), value -> "%" + value.toLowerCase() + "%"), String.class);
    }

    private <ENTITY> PredicateMapping isEmpty(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.noValueMapping(fieldPredicate, column -> criteria.getBuilder().equal((Expression)criteria.getRoot().get(column), (Object)""));
    }

    private <ENTITY> PredicateMapping isNotEmpty(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        return this.noValueMapping(fieldPredicate, column -> criteria.getBuilder().notEqual((Expression)criteria.getRoot().get(column), (Object)""));
    }

    private <ENTITY> PredicateMapping noValueMapping(FieldPredicate<ENTITY> fieldPredicate, Function<String, Predicate> callback) {
        String column = fieldPredicate.getField().columnName();
        return new PredicateMapping(callback.apply(column), new QueryParameter[0]);
    }

    private <ENTITY, S> PredicateMapping typeMapping(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate, ParameterizedPredicate<String, S> parameterizedPredicate, Class<S> clazz) {
        String column = fieldPredicate.getField().columnName();
        Object value = Cast.castOrFail(fieldPredicate, HasArg0.class).get0();
        if (clazz.isInstance(value)) {
            S val = parameterizedPredicate.getValueMapper().apply(value);
            ParameterExpression parameter = criteria.getBuilder().parameter(clazz);
            InternalQueryParameter<S> queryParameter = new InternalQueryParameter<S>(parameter, val);
            return new PredicateMapping(parameterizedPredicate.getParameterMapper().apply(column, parameter), queryParameter);
        }
        throw new JPAStreamerException();
    }

    private <ENTITY> PredicateMapping singleBoundRangeComparisonMapping(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate, ParameterizedPredicate<String, Number> parameterizedNumberPredicate, ParameterizedPredicate<String, Comparable> parameterizedComparablePredicate) {
        String column = fieldPredicate.getField().columnName();
        Object value = Cast.castOrFail(fieldPredicate, HasArg0.class).get0();
        if (value instanceof Number) {
            Number val = parameterizedNumberPredicate.getValueMapper().apply((Number)value);
            ParameterExpression numberParameter = criteria.getBuilder().parameter(Number.class);
            InternalQueryParameter<Number> queryParameter = new InternalQueryParameter<Number>(numberParameter, val);
            return new PredicateMapping(parameterizedNumberPredicate.getParameterMapper().apply(column, (ParameterExpression<Number>)numberParameter), queryParameter);
        }
        if (value instanceof Character) {
            Number val = parameterizedNumberPredicate.getValueMapper().apply((int)((Character)value).charValue());
            ParameterExpression numberParameter = criteria.getBuilder().parameter(Number.class);
            InternalQueryParameter<Number> queryParameter = new InternalQueryParameter<Number>(numberParameter, val);
            return new PredicateMapping(parameterizedNumberPredicate.getParameterMapper().apply(column, (ParameterExpression<Number>)numberParameter), queryParameter);
        }
        if (value instanceof Comparable) {
            Comparable val = parameterizedComparablePredicate.getValueMapper().apply((Comparable)value);
            ParameterExpression comparableParameter = criteria.getBuilder().parameter(Comparable.class);
            InternalQueryParameter<Comparable> queryParameter = new InternalQueryParameter<Comparable>(comparableParameter, val);
            return new PredicateMapping(parameterizedComparablePredicate.getParameterMapper().apply(column, (ParameterExpression<Comparable>)comparableParameter), queryParameter);
        }
        throw new JPAStreamerException("Illegal comparison value [" + String.valueOf(value) + "]");
    }

    private <ENTITY> PredicateMapping doubleBoundRangeComparisonMapping(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate, TriFunction<String, Pair<ParameterExpression<?>, ParameterExpression<?>>, Inclusion, Predicate> callback) {
        String column = fieldPredicate.getField().columnName();
        Object arg0 = Cast.castOrFail(fieldPredicate, HasArg0.class).get0();
        Object arg1 = Cast.castOrFail(fieldPredicate, HasArg1.class).get1();
        Inclusion inclusion = Cast.cast(fieldPredicate, HasInclusion.class).map(HasInclusion::getInclusion).orElse(Inclusion.START_INCLUSIVE_END_INCLUSIVE);
        if (arg0 instanceof Comparable && arg1 instanceof Comparable) {
            ParameterExpression lowerBoundParameter = criteria.getBuilder().parameter(Comparable.class);
            ParameterExpression upperBoundParameter = criteria.getBuilder().parameter(Comparable.class);
            InternalQueryParameter<Comparable> lowerBoundQueryParameter = new InternalQueryParameter<Comparable>(lowerBoundParameter, (Comparable)arg0);
            InternalQueryParameter<Comparable> upperBoundQueryParameter = new InternalQueryParameter<Comparable>(upperBoundParameter, (Comparable)arg1);
            return new PredicateMapping((Predicate)callback.apply((Object)column, new Pair<ParameterExpression, ParameterExpression>(lowerBoundParameter, upperBoundParameter), (Object)inclusion), lowerBoundQueryParameter, upperBoundQueryParameter);
        }
        throw new JPAStreamerException("Illegal comparison values [" + String.valueOf(arg0) + "," + String.valueOf(arg1) + "]");
    }

    private <ENTITY> PredicateMapping mapPredicate0(Criteria<ENTITY, ?> criteria, FieldPredicate<ENTITY> fieldPredicate) {
        switch (fieldPredicate.getPredicateType()) {
            case ALWAYS_TRUE: {
                return this.alwaysTrue(criteria, fieldPredicate);
            }
            case ALWAYS_FALSE: {
                return this.alwaysFalse(criteria, fieldPredicate);
            }
            case IS_NULL: {
                return this.isNull(criteria, fieldPredicate);
            }
            case IS_NOT_NULL: {
                return this.isNotNull(criteria, fieldPredicate);
            }
            case EQUAL: {
                return this.equal(criteria, fieldPredicate);
            }
            case NOT_EQUAL: {
                return this.notEqual(criteria, fieldPredicate);
            }
            case GREATER_THAN: {
                return this.greaterThan(criteria, fieldPredicate);
            }
            case GREATER_OR_EQUAL: {
                return this.greaterOrEqual(criteria, fieldPredicate);
            }
            case LESS_THAN: {
                return this.lessThan(criteria, fieldPredicate);
            }
            case LESS_OR_EQUAL: {
                return this.lessOrEqual(criteria, fieldPredicate);
            }
            case BETWEEN: {
                return this.between(criteria, fieldPredicate);
            }
            case NOT_BETWEEN: {
                return this.notBetween(criteria, fieldPredicate);
            }
            case IN: {
                return this.in(criteria, fieldPredicate);
            }
            case NOT_IN: {
                return this.notIn(criteria, fieldPredicate);
            }
            case EQUAL_IGNORE_CASE: {
                return this.equalIgnoreCase(criteria, fieldPredicate);
            }
            case NOT_EQUAL_IGNORE_CASE: {
                return this.notEqualIgnoreCase(criteria, fieldPredicate);
            }
            case STARTS_WITH: {
                return this.startsWith(criteria, fieldPredicate);
            }
            case NOT_STARTS_WITH: {
                return this.notStartsWith(criteria, fieldPredicate);
            }
            case STARTS_WITH_IGNORE_CASE: {
                return this.startsWithIgnoreCase(criteria, fieldPredicate);
            }
            case NOT_STARTS_WITH_IGNORE_CASE: {
                return this.notStartsWithIgnoreCase(criteria, fieldPredicate);
            }
            case ENDS_WITH: {
                return this.endsWith(criteria, fieldPredicate);
            }
            case NOT_ENDS_WITH: {
                return this.notEndsWith(criteria, fieldPredicate);
            }
            case ENDS_WITH_IGNORE_CASE: {
                return this.endsWithIgnoreCase(criteria, fieldPredicate);
            }
            case NOT_ENDS_WITH_IGNORE_CASE: {
                return this.notEndsWithIgnoreCase(criteria, fieldPredicate);
            }
            case CONTAINS: {
                return this.contains(criteria, fieldPredicate);
            }
            case NOT_CONTAINS: {
                return this.notContains(criteria, fieldPredicate);
            }
            case CONTAINS_IGNORE_CASE: {
                return this.containsIgnoreCase(criteria, fieldPredicate);
            }
            case NOT_CONTAINS_IGNORE_CASE: {
                return this.notContainsIgnoreCase(criteria, fieldPredicate);
            }
            case IS_EMPTY: {
                return this.isEmpty(criteria, fieldPredicate);
            }
            case IS_NOT_EMPTY: {
                return this.isNotEmpty(criteria, fieldPredicate);
            }
        }
        throw new JPAStreamerException("Predicate type [" + String.valueOf(fieldPredicate.getPredicateType()) + "] is not supported");
    }

    private static final class Pair<S, T> {
        private final S first;
        private final T second;

        private Pair(S first, T second) {
            this.first = first;
            this.second = second;
        }

        public S getFirst() {
            return this.first;
        }

        public T getSecond() {
            return this.second;
        }
    }
}

