/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.criteria.standard.internal;

import com.speedment.jpastreamer.criteria.Criteria;
import com.speedment.jpastreamer.criteria.PredicateFactory;
import com.speedment.jpastreamer.criteria.standard.internal.predicate.PredicateMapper;
import com.speedment.jpastreamer.criteria.standard.internal.predicate.PredicateMapping;
import com.speedment.jpastreamer.exception.JPAStreamerException;
import com.speedment.jpastreamer.field.predicate.CombinedPredicate;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;

public final class InternalPredicateFactory
implements PredicateFactory {
    private final PredicateMapper predicateMapper = PredicateMapper.createPredicateMapper();

    public <ENTITY> Predicate createPredicate(Criteria<ENTITY, ?> criteria, SpeedmentPredicate<ENTITY> speedmentPredicate) {
        Objects.requireNonNull(criteria);
        Objects.requireNonNull(speedmentPredicate);
        if (speedmentPredicate instanceof FieldPredicate) {
            FieldPredicate fieldPredicate = (FieldPredicate)speedmentPredicate;
            PredicateMapping predicateMapping = this.predicateMapper.mapPredicate(criteria, fieldPredicate);
            predicateMapping.getQueryParameters().forEach(arg_0 -> criteria.addQueryParameter(arg_0));
            return predicateMapping.getPredicate();
        }
        if (speedmentPredicate instanceof CombinedPredicate) {
            CombinedPredicate combinedPredicate = (CombinedPredicate)speedmentPredicate;
            Predicate[] predicates = (Predicate[])combinedPredicate.stream().map(predicate -> {
                if (predicate instanceof SpeedmentPredicate) {
                    return this.createPredicate(criteria, (SpeedmentPredicate)predicate);
                }
                throw this.newJPAStreamerException("type", predicate.getClass().getSimpleName());
            }).toArray(Predicate[]::new);
            switch (combinedPredicate.getType()) {
                case AND: {
                    return criteria.getBuilder().and(predicates);
                }
                case OR: {
                    return criteria.getBuilder().or(predicates);
                }
            }
            throw this.newJPAStreamerException("logical operator", combinedPredicate.getType().toString());
        }
        throw this.newJPAStreamerException("logical type", speedmentPredicate.getClass().getSimpleName());
    }

    private JPAStreamerException newJPAStreamerException(String item, String typeName) {
        return new JPAStreamerException("Predicate " + item + " [" + typeName + "] is not supported");
    }
}

