/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.criteria;

import com.speedment.jpastreamer.criteria.Criteria;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import java.util.Objects;

public interface CriteriaFactory {
    public <ENTITY, RETURN> Criteria<ENTITY, RETURN> createCriteria(CriteriaBuilder var1, CriteriaQuery<RETURN> var2, Root<ENTITY> var3);

    default public <ENTITY> Criteria<ENTITY, ENTITY> createCriteria(EntityManager entityManager, Class<ENTITY> entityClass) {
        return this.createCriteria(entityManager, entityClass, entityClass);
    }

    default public <ENTITY, RETURN> Criteria<ENTITY, RETURN> createCriteria(EntityManager entityManager, Class<ENTITY> entityClass, Class<RETURN> returnClass) {
        Objects.requireNonNull(entityManager);
        Objects.requireNonNull(entityClass);
        Objects.requireNonNull(returnClass);
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(returnClass);
        Root root = criteriaQuery.from(entityClass);
        return this.createCriteria(criteriaBuilder, criteriaQuery, root);
    }
}

