/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.predicate.bytes;

import com.speedment.jpastreamer.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteNotBetweenPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.PredicateType;
import com.speedment.jpastreamer.field.predicate.trait.HasInclusion;
import com.speedment.jpastreamer.field.trait.HasArg0;
import com.speedment.jpastreamer.field.trait.HasArg1;
import com.speedment.jpastreamer.field.trait.HasByteValue;
import java.util.Objects;

public final class ByteBetweenPredicate<ENTITY>
extends AbstractFieldPredicate<ENTITY, HasByteValue<ENTITY>>
implements HasInclusion,
HasArg0<Byte>,
HasArg1<Byte> {
    private final byte start;
    private final byte end;
    private final Inclusion inclusion;

    public ByteBetweenPredicate(HasByteValue<ENTITY> field, byte start, byte end, Inclusion inclusion) {
        super(PredicateType.BETWEEN, field, entity -> {
            byte fieldValue = field.getAsByte(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start < fieldValue && end > fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start < fieldValue && end >= fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start <= fieldValue && end > fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start <= fieldValue && end >= fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    @Override
    public Byte get0() {
        return this.start;
    }

    @Override
    public Byte get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public ByteNotBetweenPredicate<ENTITY> negate() {
        return new ByteNotBetweenPredicate((HasByteValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

