/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.predicate.shorts;

import com.speedment.jpastreamer.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortNotBetweenPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.PredicateType;
import com.speedment.jpastreamer.field.predicate.trait.HasInclusion;
import com.speedment.jpastreamer.field.trait.HasArg0;
import com.speedment.jpastreamer.field.trait.HasArg1;
import com.speedment.jpastreamer.field.trait.HasShortValue;
import java.util.Objects;

public final class ShortBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasShortValue<ENTITY>>
implements HasInclusion,
HasArg0<Short>,
HasArg1<Short> {
    private final short start;
    private final short end;
    private final Inclusion inclusion;

    public ShortBetweenPredicate(HasShortValue<ENTITY> field, short start, short end, Inclusion inclusion) {
        super(PredicateType.BETWEEN, field, entity -> {
            short fieldValue = field.getAsShort(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start < fieldValue && end > fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start < fieldValue && end >= fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start <= fieldValue && end > fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start <= fieldValue && end >= fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    @Override
    public Short get0() {
        return this.start;
    }

    @Override
    public Short get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public ShortNotBetweenPredicate<ENTITY, D> negate() {
        return new ShortNotBetweenPredicate((HasShortValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

