/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.BooleanField;
import com.speedment.jpastreamer.field.comparator.BooleanFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.BooleanFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetBooleanImpl;
import com.speedment.jpastreamer.field.internal.predicate.booleans.BooleanEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.booleans.BooleanNotEqualPredicate;
import com.speedment.jpastreamer.field.method.BooleanGetter;
import com.speedment.jpastreamer.field.method.GetBoolean;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Objects;

public final class BooleanFieldImpl<ENTITY>
implements BooleanField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetBoolean<ENTITY> getter;
    private final boolean unique;

    public BooleanFieldImpl(Class<ENTITY> table, String columnName, BooleanGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetBooleanImpl<ENTITY>(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetBoolean<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public BooleanFieldComparator<ENTITY> reversed() {
        return new BooleanFieldComparatorImpl(this).reversed();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(boolean value) {
        return new BooleanEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(boolean value) {
        return new BooleanNotEqualPredicate(this, value);
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

