/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.LongField;
import com.speedment.jpastreamer.field.comparator.LongFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.LongFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetLongImpl;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.longs.LongNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.GetLong;
import com.speedment.jpastreamer.field.method.LongGetter;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class LongFieldImpl<ENTITY>
implements LongField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetLong<ENTITY> getter;
    private final boolean unique;

    public LongFieldImpl(Class<ENTITY> table, String columnName, LongGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetLongImpl<ENTITY>(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetLong<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public LongFieldComparator<ENTITY> comparator() {
        return new LongFieldComparatorImpl(this);
    }

    @Override
    public LongFieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public LongFieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Long value) {
        return new LongEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Long value) {
        return new LongGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Long value) {
        return new LongGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Long start, Long end, Inclusion inclusion) {
        return new LongBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Long> values) {
        return new LongInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Long value) {
        return new LongNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Long value) {
        return new LongLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Long value) {
        return new LongLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Long start, Long end, Inclusion inclusion) {
        return new LongNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Long> values) {
        return new LongNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

