/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.fieldgenerator.internal;

import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.controller.AlignTabs;
import com.speedment.common.codegen.controller.AutoImports;
import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.util.Formatting;
import com.speedment.jpastreamer.field.BooleanField;
import com.speedment.jpastreamer.field.ByteField;
import com.speedment.jpastreamer.field.CharField;
import com.speedment.jpastreamer.field.ComparableField;
import com.speedment.jpastreamer.field.DoubleField;
import com.speedment.jpastreamer.field.EnumField;
import com.speedment.jpastreamer.field.FloatField;
import com.speedment.jpastreamer.field.IntField;
import com.speedment.jpastreamer.field.LongField;
import com.speedment.jpastreamer.field.ReferenceField;
import com.speedment.jpastreamer.field.ShortField;
import com.speedment.jpastreamer.field.StringField;
import com.speedment.jpastreamer.field.exception.IllegalJavaBeanException;
import com.speedment.jpastreamer.fieldgenerator.exception.FieldGeneratorProcessorException;
import com.speedment.jpastreamer.fieldgenerator.internal.typeparser.TypeParser;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class InternalFieldGeneratorProcessor
extends AbstractProcessor {
    protected static final String GET_PREFIX = "get";
    protected static final String IS_PREFIX = "is";
    private static final Generator generator = Generator.forJava();
    private ProcessingEnvironment processingEnvironment;
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;
    private static final Set<String> DISALLOWED_ACCESS_LEVELS = Stream.of("PROTECTED", "PRIVATE", "NONE").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.processingEnvironment = env;
        this.elementUtils = this.processingEnvironment.getElementUtils();
        this.typeUtils = this.processingEnvironment.getTypeUtils();
        this.messager = this.processingEnvironment.getMessager();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "JPA Streamer Field Generator Processor");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty() || roundEnv.processingOver()) {
            return false;
        }
        roundEnv.getElementsAnnotatedWith(Entity.class).stream().filter(ae -> ae.getKind() == ElementKind.CLASS).forEach(ae -> {
            try {
                String qualifiedGenEntityName = ae.asType().toString() + "$";
                JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(qualifiedGenEntityName, new Element[0]);
                Writer writer = builderFile.openWriter();
                this.generateFields((Element)ae, writer);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return true;
    }

    void generateFields(Element annotatedElement, Writer writer) throws IOException {
        String packageName;
        String entityName = Formatting.shortName((String)annotatedElement.asType().toString());
        String genEntityName = entityName + "$";
        Map getters = annotatedElement.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).filter(ee -> ee.getEnclosedElements().stream().noneMatch(eee -> eee.getKind() == ElementKind.PARAMETER)).collect(Collectors.toMap(e -> e.getSimpleName().toString(), Function.identity()));
        Set isGetters = getters.values().stream().map(Element::getSimpleName).map(Object::toString).filter(n -> n.startsWith(IS_PREFIX)).map(n -> n.substring(2)).map(Formatting::lcfirst).collect(Collectors.toSet());
        Map enclosedFields = annotatedElement.getEnclosedElements().stream().filter(ee -> ee.getKind().isField() && !ee.getModifiers().contains((Object)Modifier.STATIC) && !ee.getModifiers().contains((Object)Modifier.FINAL)).collect(Collectors.toMap(Function.identity(), ee -> this.findGetter((Element)ee, getters, isGetters, entityName, this.lombokGetterAvailable(annotatedElement, (Element)ee))));
        PackageElement packageElement = this.processingEnvironment.getElementUtils().getPackageOf(annotatedElement);
        if (packageElement.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Class " + entityName + " has an unnamed package.");
            packageName = "";
        } else {
            packageName = packageElement.getQualifiedName().toString();
        }
        File file = this.generatedEntity(enclosedFields, entityName, genEntityName, packageName);
        writer.write((String)generator.on((Object)file).orElseThrow(NoSuchElementException::new));
    }

    private String findGetter(Element field, Map<String, Element> getters, Set<String> isGetters, String entityName, boolean lombokGetterAvailable) {
        String fieldName = field.getSimpleName().toString();
        String getterPrefix = isGetters.contains(fieldName) ? IS_PREFIX : GET_PREFIX;
        String standardJavaName = Formatting.javaNameFromExternal((String)fieldName);
        String standardGetterName = getterPrefix + standardJavaName;
        if (getters.get(standardGetterName) != null || isGetters.contains(standardGetterName)) {
            return entityName + "::" + standardGetterName;
        }
        if (lombokGetterAvailable) {
            TypeKind typeKind = field.asType().getKind();
            return typeKind.isPrimitive() && typeKind == TypeKind.BOOLEAN ? entityName + "::" + IS_PREFIX + standardJavaName : entityName + "::" + GET_PREFIX + standardJavaName;
        }
        String lambdaName = Formatting.lcfirst((String)entityName);
        if (!field.getModifiers().contains((Object)Modifier.PROTECTED) && !field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return lambdaName + " -> " + lambdaName + "." + fieldName;
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, "Class " + entityName + " is not a proper JavaBean because " + field.getSimpleName().toString() + " has no standard getter. Fix the issue to ensure stability.");
        return lambdaName + " -> {throw new " + IllegalJavaBeanException.class.getSimpleName() + "(" + entityName + ".class, \"" + fieldName + "\");}";
    }

    private File generatedEntity(Map<? extends Element, String> enclosedFields, String entityName, String genEntityName, String packageName) {
        File file = packageName.isEmpty() ? File.of((String)(genEntityName + ".java")) : File.of((String)(packageName + "/" + genEntityName + ".java"));
        com.speedment.common.codegen.model.Class clazz = (com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)com.speedment.common.codegen.model.Class.of((String)genEntityName).public_()).final_()).set((Javadoc)Javadoc.of((String)("The generated base for entity {@link " + entityName + "} representing entities of the {@code " + Formatting.lcfirst((String)entityName) + "}-table in the database." + Formatting.nl() + "<p> This file has been automatically generated by JPAStreamer.")).author("JPAStreamer"));
        enclosedFields.forEach((field, getter) -> {
            this.addFieldToClass((Element)field, (String)getter, clazz, entityName);
            if (getter.contains(IllegalJavaBeanException.class.getSimpleName())) {
                file.add(Import.of(IllegalJavaBeanException.class));
            }
        });
        file.add((ClassOrInterface)clazz);
        ((File)file.call((Consumer)new AutoImports(generator.getDependencyMgr()))).call((Consumer)new AlignTabs());
        return file;
    }

    private void addFieldToClass(Element field, String getter, com.speedment.common.codegen.model.Class clazz, String entityName) {
        String fieldName = field.getSimpleName().toString();
        Type referenceType = this.referenceType(field, entityName);
        ArrayList<Object> fieldParams = new ArrayList<Object>();
        fieldParams.add(Value.ofReference((String)(entityName + ".class")));
        fieldParams.add(Value.ofText((String)fieldName));
        fieldParams.add(Value.ofReference((String)getter));
        TypeElement typeElement = this.elementUtils.getTypeElement(this.fieldType(field).getTypeName());
        TypeMirror enumType = this.elementUtils.getTypeElement("java.lang.Enum").asType();
        if (typeElement != null && this.typeUtils.isAssignable(typeElement.asType(), enumType)) {
            String fieldTypeName = Formatting.shortName((String)this.fieldType(field).getTypeName());
            fieldParams.add(Value.ofReference((String)(fieldTypeName + ".class")));
        } else {
            Column col = field.getAnnotation(Column.class);
            fieldParams.add(Value.ofBoolean((Boolean)(col != null && col.unique() ? 1 : 0)));
        }
        clazz.add((Field)((Field)((Field)((Field)((Field)Field.of((String)fieldName, (Type)referenceType).public_()).static_()).final_()).set((Value)Value.ofInvocation((Type)referenceType, (String)"create", (Value[])fieldParams.toArray(new Value[0])))).set(Javadoc.of((String)("This Field corresponds to the {@link " + entityName + "} field \"" + fieldName + "\"."))));
    }

    private Type referenceType(Element field, String entityName) {
        Type type;
        Type fieldType = this.fieldType(field);
        SimpleType entityType = SimpleType.create((String)entityName);
        TypeElement typeElement = this.elementUtils.getTypeElement(this.fieldType(field).getTypeName());
        TypeMirror enumType = this.elementUtils.getTypeElement("java.lang.Enum").asType();
        TypeMirror comparableType = this.typeUtils.erasure(this.elementUtils.getTypeElement("java.lang.Comparable").asType());
        try {
            type = field.asType().getKind().isPrimitive() ? this.primitiveFieldType(fieldType, (Type)entityType) : (typeElement != null && this.typeUtils.isAssignable(typeElement.asType(), enumType) ? SimpleParameterizedType.create(EnumField.class, (Type[])new Type[]{entityType, fieldType}) : (typeElement != null && this.typeUtils.isAssignable(typeElement.asType(), comparableType) && field.getAnnotation(Lob.class) == null ? (this.fieldType(field).getTypeName().contains("String") ? SimpleParameterizedType.create(StringField.class, (Type[])new Type[]{entityType}) : SimpleParameterizedType.create(ComparableField.class, (Type[])new Type[]{entityType, fieldType})) : SimpleParameterizedType.create(ReferenceField.class, (Type[])new Type[]{entityType, fieldType})));
        }
        catch (UnsupportedOperationException e) {
            throw new FieldGeneratorProcessorException("Primitive type " + fieldType.getTypeName() + " could not be parsed.");
        }
        return type;
    }

    private Type fieldType(Element field) {
        TypeParser typeParser = new TypeParser();
        return typeParser.render(this.trimAnnotations(field));
    }

    private String trimAnnotations(Element field) {
        String fieldType = field.asType().toString();
        int index = fieldType.lastIndexOf(32);
        return index < 0 ? fieldType : fieldType.substring(index + 1);
    }

    private Type primitiveFieldType(Type fieldType, Type entityType) {
        Class<IntField> primitiveFieldType;
        switch (fieldType.getTypeName()) {
            case "int": {
                primitiveFieldType = IntField.class;
                break;
            }
            case "byte": {
                primitiveFieldType = ByteField.class;
                break;
            }
            case "short": {
                primitiveFieldType = ShortField.class;
                break;
            }
            case "long": {
                primitiveFieldType = LongField.class;
                break;
            }
            case "float": {
                primitiveFieldType = FloatField.class;
                break;
            }
            case "double": {
                primitiveFieldType = DoubleField.class;
                break;
            }
            case "char": {
                primitiveFieldType = CharField.class;
                break;
            }
            case "boolean": {
                primitiveFieldType = BooleanField.class;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown primitive type: '" + fieldType.getTypeName() + "'.");
            }
        }
        return SimpleParameterizedType.create(primitiveFieldType, (Type[])new Type[]{entityType});
    }

    private boolean lombokGetterAvailable(Element classElement, Element fieldElement) {
        boolean globalEnable = this.isLombokAnnotated(classElement, "Data") || this.isLombokAnnotated(classElement, "Getter");
        boolean localEnable = this.isLombokAnnotated(fieldElement, "Getter");
        boolean disallowedAccessLevel = DISALLOWED_ACCESS_LEVELS.contains(this.getterAccessLevel(fieldElement).orElse("No access level defined"));
        return !disallowedAccessLevel && (globalEnable || localEnable);
    }

    private boolean isLombokAnnotated(Element annotatedElement, String lombokSimpleClassName) {
        try {
            String className = "lombok." + lombokSimpleClassName;
            Class<?> clazz = Class.forName(className);
            return annotatedElement.getAnnotation(clazz) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Optional<String> getterAccessLevel(Element fieldElement) {
        List<? extends AnnotationMirror> mirrors = fieldElement.getAnnotationMirrors();
        Map map = mirrors.stream().filter(am -> "lombok.Getter".equals(am.getAnnotationType().toString())).findFirst().map(AnnotationMirror::getElementValues).orElse(Collections.emptyMap());
        return map.values().stream().map(AnnotationValue::toString).map(v -> v.substring(v.lastIndexOf(46) + 1)).filter(this::isAccessLevel).findFirst();
    }

    private boolean isAccessLevel(String s) {
        Set validAccessLevels = Stream.of("PACKAGE", "NONE", "PRIVATE", "MODULE", "PROTECTED", "PUBLIC").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        return validAccessLevels.contains(s);
    }
}

