/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.fieldgenerator.internal.typeparser;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Node {
    private final Type type;
    private List<Node> children;

    Node(Type type) {
        this.type = type;
        this.children = new ArrayList<Node>();
    }

    Node(Type type, Node ... children) {
        this.type = type;
        this.children = new ArrayList<Node>();
        this.children.addAll(Arrays.asList(children));
    }

    void addChild(Node child) {
        this.children.add(child);
    }

    Type type() {
        return this.type;
    }

    List<Node> children() {
        return this.children;
    }

    boolean isLeaf() {
        return this.children.isEmpty();
    }

    public String toString() {
        return this.type.getTypeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.type.equals(node.type) && this.children.equals(node.children);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.children);
    }
}

