/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.fieldgenerator.internal.typeparser;

import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.jpastreamer.fieldgenerator.exception.TypeParserException;
import com.speedment.jpastreamer.fieldgenerator.internal.typeparser.Node;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class TypeParser {
    public Type render(String s) throws TypeParserException {
        if (!this.hasBalancedBrackets(s)) {
            throw new TypeParserException("String " + s + " has imbalanced brackets, hence is not a valid type expression");
        }
        Node root = this.parseNode(s);
        return this.render(root);
    }

    private Type render(Node node) {
        if (node.isLeaf()) {
            return node.type();
        }
        Type[] childTypes = (Type[])node.children().stream().map(this::render).toArray(Type[]::new);
        return SimpleParameterizedType.create((Type)node.type(), (Type[])childTypes);
    }

    private Node parseNode(String s) {
        if (s.startsWith("@")) {
            s = s.substring(s.indexOf(32) + 1);
        }
        if (!s.contains("<") && !s.contains(",")) {
            return new Node((Type)SimpleType.create((String)s));
        }
        Node node = new Node((Type)SimpleType.create((String)s.substring(0, s.indexOf("<"))));
        List<String> params = this.parameters(s.substring(s.indexOf(60) + 1, s.lastIndexOf(62)));
        for (String param : params) {
            node.addChild(this.parseNode(param));
        }
        return node;
    }

    private boolean hasBalancedBrackets(String s) {
        int openBr = 0;
        for (int pos = 0; pos < s.length(); ++pos) {
            if (openBr == -1) {
                return false;
            }
            if (s.charAt(pos) == '<') {
                ++openBr;
                continue;
            }
            if (s.charAt(pos) != '>') continue;
            --openBr;
        }
        return openBr == 0;
    }

    private boolean hasBalancedBracketsAtPos(String s, int pos) {
        return this.hasBalancedBrackets(s.substring(0, pos));
    }

    private List<String> parameters(String s) {
        ArrayList<String> children = new ArrayList<String>();
        if (!s.contains(",")) {
            children.add(s);
            return children;
        }
        int pos = 0;
        String str = s;
        while (str.substring(pos).contains(",")) {
            if (this.hasBalancedBracketsAtPos(str, pos = str.indexOf(44, pos))) {
                children.add(str.substring(0, pos).trim());
                str = str.substring(pos + 1);
                pos = 0;
                continue;
            }
            ++pos;
        }
        children.add(str.trim());
        return children;
    }
}

