/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.javasixteen.internal;

import com.speedment.jpastreamer.exception.JPAStreamerException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class InternalJava16StreamUtil {
    private static final String TO_LIST = "toList";
    private static final String MAP_MULTI = "mapMulti";
    private static final String MAP_MULTI_TO_INT = "mapMultiToInt";
    private static final String MAP_MULTI_TO_LONG = "mapMultiToLong";
    private static final String MAP_MULTI_TO_DOUBLE = "mapMultiToDouble";
    private static final MethodType MAP_MULTI_DOUBLE_METHOD_TYPE = MethodType.methodType(DoubleStream.class, BiConsumer.class);
    static final MethodHandle MAP_MULTI_DOUBLE_HANDLE = InternalJava16StreamUtil.createMethodHandle("mapMultiToDouble", Stream.class, MAP_MULTI_DOUBLE_METHOD_TYPE);
    private static final MethodType MAP_MULTI_LONG_METHOD_TYPE = MethodType.methodType(LongStream.class, BiConsumer.class);
    static final MethodHandle MAP_MULTI_LONG_HANDLE = InternalJava16StreamUtil.createMethodHandle("mapMultiToLong", Stream.class, MAP_MULTI_LONG_METHOD_TYPE);
    private static final MethodType MAP_MULTI_INT_METHOD_TYPE = MethodType.methodType(IntStream.class, BiConsumer.class);
    static final MethodHandle MAP_MULTI_INT_HANDLE = InternalJava16StreamUtil.createMethodHandle("mapMultiToInt", Stream.class, MAP_MULTI_INT_METHOD_TYPE);
    private static final MethodType MAP_MULTI_METHOD_TYPE = MethodType.methodType(Stream.class, BiConsumer.class);
    private static final MethodHandle MAP_MULTI_METHOD_HANDLE = InternalJava16StreamUtil.createMethodHandle("mapMulti", Stream.class, MAP_MULTI_METHOD_TYPE);
    private static final MethodType TO_LIST_METHOD_TYPE = MethodType.methodType(List.class);
    private static final MethodHandle TO_LIST_METHOD_HANDLE = InternalJava16StreamUtil.createMethodHandle("toList", Stream.class, TO_LIST_METHOD_TYPE);

    private InternalJava16StreamUtil() {
    }

    public static <T> List<T> toList(Stream<T> stream) {
        Objects.requireNonNull(stream);
        if (TO_LIST_METHOD_HANDLE == null) {
            throw InternalJava16StreamUtil.newUnsupportedOperationException(TO_LIST);
        }
        try {
            Object obj = TO_LIST_METHOD_HANDLE.invoke(stream);
            return (List)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static <T, R> Stream<R> mapMulti(Stream<T> stream, BiConsumer<? super T, ? super Consumer<R>> mapper) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(mapper);
        if (MAP_MULTI_METHOD_HANDLE == null) {
            throw InternalJava16StreamUtil.newUnsupportedOperationException(MAP_MULTI);
        }
        try {
            Object obj = MAP_MULTI_METHOD_HANDLE.invoke(stream, mapper);
            return (Stream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static <T> IntStream mapMultiToInt(Stream<T> stream, BiConsumer<? super T, ? super IntConsumer> mapper) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(mapper);
        if (MAP_MULTI_INT_HANDLE == null) {
            throw InternalJava16StreamUtil.newUnsupportedOperationException(MAP_MULTI);
        }
        try {
            Object obj = MAP_MULTI_INT_HANDLE.invoke(stream, mapper);
            return (IntStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static <T> DoubleStream mapMultiToDouble(Stream<T> stream, BiConsumer<? super T, ? super DoubleConsumer> mapper) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(mapper);
        if (MAP_MULTI_DOUBLE_HANDLE == null) {
            throw InternalJava16StreamUtil.newUnsupportedOperationException(MAP_MULTI);
        }
        try {
            Object obj = MAP_MULTI_DOUBLE_HANDLE.invoke(stream, mapper);
            return (DoubleStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static <T> LongStream mapMultiToLong(Stream<T> stream, BiConsumer<? super T, ? super LongConsumer> mapper) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(mapper);
        if (MAP_MULTI_LONG_HANDLE == null) {
            throw InternalJava16StreamUtil.newUnsupportedOperationException(MAP_MULTI);
        }
        try {
            Object obj = MAP_MULTI_LONG_HANDLE.invoke(stream, mapper);
            return (LongStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    private static MethodHandle createMethodHandle(String methodName, Class<?> refc, MethodType methodType) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findVirtual(refc, methodName, methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static UnsupportedOperationException newUnsupportedOperationException(String methodName) {
        return new UnsupportedOperationException("Stream::" + methodName + " is not supported by this Java version. Use Java 16 or greater.");
    }
}

