/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.merger.standard.internal.criteria.strategy;

import com.speedment.jpastreamer.criteria.Criteria;
import com.speedment.jpastreamer.criteria.PredicateFactory;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import com.speedment.jpastreamer.merger.standard.internal.criteria.strategy.CriteriaModifier;
import com.speedment.jpastreamer.merger.standard.internal.reference.IntermediateOperationReference;
import com.speedment.jpastreamer.merger.standard.internal.tracker.MergingTracker;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;

public enum FilterCriteriaModifier implements CriteriaModifier
{
    INSTANCE;

    private final PredicateFactory predicateFactory = (PredicateFactory)RootFactory.getOrThrow(PredicateFactory.class, ServiceLoader::load);

    @Override
    public <ENTITY> void modifyCriteria(IntermediateOperationReference operationReference, Criteria<ENTITY, ?> criteria, MergingTracker mergingTracker) {
        Objects.requireNonNull(operationReference);
        Objects.requireNonNull(criteria);
        Objects.requireNonNull(mergingTracker);
        IntermediateOperation<?, ?> operation = operationReference.get();
        IntermediateOperationType operationType = (IntermediateOperationType)operation.type();
        if (operationType != IntermediateOperationType.FILTER) {
            return;
        }
        this.getPredicate(operation).ifPresent(speedmentPredicate -> {
            Predicate predicate = this.predicateFactory.createPredicate(criteria, speedmentPredicate);
            criteria.getQuery().where((Expression)predicate);
            mergingTracker.markAsMerged(operationType);
            mergingTracker.markForRemoval(operationReference.index());
        });
    }

    private <T> Optional<SpeedmentPredicate<T>> getPredicate(IntermediateOperation<?, ?> operation) {
        Object[] arguments = operation.arguments();
        if (arguments.length != 1) {
            return Optional.empty();
        }
        if (arguments[0] instanceof SpeedmentPredicate) {
            return Optional.of((SpeedmentPredicate)arguments[0]);
        }
        return Optional.empty();
    }
}

