/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.merger.standard.internal.criteria.strategy;

import com.speedment.jpastreamer.criteria.Criteria;
import com.speedment.jpastreamer.criteria.OrderFactory;
import com.speedment.jpastreamer.exception.JPAStreamerException;
import com.speedment.jpastreamer.merger.standard.internal.criteria.strategy.CriteriaModifier;
import com.speedment.jpastreamer.merger.standard.internal.reference.IntermediateOperationReference;
import com.speedment.jpastreamer.merger.standard.internal.tracker.MergingTracker;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;

public enum SortedCriteriaModifier implements CriteriaModifier
{
    INSTANCE;

    private final OrderFactory orderFactory = (OrderFactory)RootFactory.getOrThrow(OrderFactory.class, ServiceLoader::load);

    @Override
    public <ENTITY> void modifyCriteria(IntermediateOperationReference operationReference, Criteria<ENTITY, ?> criteria, MergingTracker mergingTracker) {
        Objects.requireNonNull(operationReference);
        Objects.requireNonNull(criteria);
        Objects.requireNonNull(mergingTracker);
        IntermediateOperation<?, ?> operation = operationReference.get();
        IntermediateOperationType operationType = (IntermediateOperationType)operation.type();
        if (operationType != IntermediateOperationType.SORTED) {
            return;
        }
        Optional optionalComparator = this.getComparator(operation);
        if (optionalComparator.isPresent()) {
            List orders;
            try {
                orders = this.orderFactory.createOrder(criteria, optionalComparator.get());
            }
            catch (JPAStreamerException e) {
                return;
            }
            ArrayList previousOrders = new ArrayList(criteria.getQuery().getOrderList());
            previousOrders.addAll(orders);
            criteria.getQuery().orderBy(previousOrders);
            operationReference.next().ifPresent(op -> {
                if (op.get().type() != IntermediateOperationType.SORTED) {
                    mergingTracker.markAsMerged(operationType);
                }
            });
            mergingTracker.markForRemoval(operationReference.index());
        } else {
            EntityType entityType = criteria.getRoot().getModel();
            entityType.getDeclaredSingularAttributes().stream().filter(SingularAttribute::isId).map(Attribute::getName).findFirst().ifPresent(idFieldName -> {
                Order order = criteria.getBuilder().asc((Expression)criteria.getRoot().get(idFieldName));
                ArrayList<Order> previousOrders = new ArrayList<Order>(criteria.getQuery().getOrderList());
                previousOrders.add(order);
                criteria.getQuery().orderBy(previousOrders);
                operationReference.next().ifPresent(op -> {
                    if (op.get().type() != IntermediateOperationType.SORTED) {
                        mergingTracker.markAsMerged(operationType);
                    }
                });
                mergingTracker.markForRemoval(operationReference.index());
            });
        }
    }

    private <T> Optional<Comparator<T>> getComparator(IntermediateOperation<?, ?> operation) {
        Object[] arguments = operation.arguments();
        if (arguments.length != 1) {
            return Optional.empty();
        }
        if (arguments[0] instanceof Comparator) {
            return Optional.of((Comparator)arguments[0]);
        }
        return Optional.empty();
    }
}

