/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.merger.standard.internal.query.strategy;

import com.speedment.jpastreamer.merger.standard.internal.query.strategy.QueryModifier;
import com.speedment.jpastreamer.merger.standard.internal.reference.IntermediateOperationReference;
import com.speedment.jpastreamer.merger.standard.internal.tracker.MergingTracker;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.Query;

public enum SkipLimitModifier implements QueryModifier
{
    INSTANCE;


    @Override
    public void modifyQuery(IntermediateOperationReference operationReference, Query query, MergingTracker mergingTracker) {
        Objects.requireNonNull(operationReference);
        Objects.requireNonNull(query);
        Objects.requireNonNull(mergingTracker);
        IntermediateOperation<?, ?> operation = operationReference.get();
        IntermediateOperationType operationType = (IntermediateOperationType)operation.type();
        if (operationType != IntermediateOperationType.SKIP && operationType != IntermediateOperationType.LIMIT) {
            return;
        }
        if (operationType == IntermediateOperationType.SKIP) {
            if (mergingTracker.mergedOperations().contains(IntermediateOperationType.LIMIT)) {
                return;
            }
            query.setFirstResult((int)this.getArgument(operation));
            mergingTracker.markAsMerged(operationType);
            mergingTracker.markForRemoval(operationReference.index());
            Optional<IntermediateOperationReference> optionalNext = operationReference.next();
            if (optionalNext.isPresent()) {
                IntermediateOperationReference nextReference = optionalNext.get();
                IntermediateOperation<?, ?> next = nextReference.get();
                if (next.type() == IntermediateOperationType.LIMIT) {
                    query.setMaxResults((int)this.getArgument(next));
                    mergingTracker.markAsMerged((IntermediateOperationType)next.type());
                    mergingTracker.markForRemoval(nextReference.index());
                }
            } else {
                query.setMaxResults(Integer.MAX_VALUE);
            }
        } else {
            query.setMaxResults((int)this.getArgument(operation));
            mergingTracker.markAsMerged(operationType);
            mergingTracker.markForRemoval(operationReference.index());
        }
    }

    private long getArgument(IntermediateOperation<?, ?> intermediateOperation) {
        Object[] arguments = intermediateOperation.arguments();
        if (arguments.length != 1) {
            return 0L;
        }
        if (arguments[0] instanceof Long) {
            return (Long)arguments[0];
        }
        return 0L;
    }
}

