/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.standard.internal.pipeline;

import com.speedment.jpastreamer.pipeline.Pipeline;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class StandardPipeline<T>
implements Pipeline<T> {
    private final List<Runnable> closeHandlers;
    private final LinkedList<IntermediateOperation<?, ?>> intermediateOperations;
    private final Class<T> root;
    private TerminalOperation<?, ?> terminalOperation;
    private boolean parallel;
    private boolean unordered;

    StandardPipeline(Class<T> root) {
        this.root = Objects.requireNonNull(root);
        this.closeHandlers = new ArrayList<Runnable>();
        this.intermediateOperations = new LinkedList();
    }

    public Class<T> root() {
        return this.root;
    }

    public LinkedList<IntermediateOperation<?, ?>> intermediateOperations() {
        return this.intermediateOperations;
    }

    public TerminalOperation<?, ?> terminatingOperation() {
        return this.terminalOperation;
    }

    public void terminatingOperation(TerminalOperation<?, ?> terminalOperation) {
        this.terminalOperation = Objects.requireNonNull(terminalOperation);
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void parallel() {
        this.parallel = true;
    }

    public void sequential() {
        this.parallel = false;
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public void ordered(boolean flag) {
        this.unordered = flag;
    }

    public List<Runnable> closeHandlers() {
        return this.closeHandlers;
    }

    public String toString() {
        return String.format("%s {%n%s%s, parallel= %s, unordered= %s}", this.root.getSimpleName(), this.renderIntermediate(), this.renderTerminal(), this.parallel, this.unordered);
    }

    private String renderIntermediate() {
        return this.intermediateOperations.stream().map(io -> String.format("  .%s%n", io.toString())).collect(Collectors.joining());
    }

    private String renderTerminal() {
        return String.format("  .%s%n", this.terminalOperation == null ? "" : this.terminalOperation.toString());
    }
}

