/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.standard.internal.intermediate;

import com.speedment.jpastreamer.javanine.Java9StreamUtil;
import com.speedment.jpastreamer.pipeline.intermediate.DoubleIntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import com.speedment.jpastreamer.pipeline.standard.internal.intermediate.StandardIntermediateOperation;
import com.speedment.jpastreamer.pipeline.standard.internal.intermediate.TypeUtil;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class InternalDoubleIntermediateOperationFactory
implements DoubleIntermediateOperationFactory {
    private static final Function<DoubleStream, DoubleStream> SORTED_FUNCTION = DoubleStream::sorted;
    private static final IntermediateOperation<DoubleStream, DoubleStream> SORTED = new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.SORTED, DoubleStream.class, DoubleStream.class, SORTED_FUNCTION, new Object[0]);
    private static final Function<DoubleStream, DoubleStream> DISTINCT_FUNCTION = DoubleStream::distinct;
    private static final IntermediateOperation<DoubleStream, DoubleStream> DISTINCT = new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.DISTINCT, DoubleStream.class, DoubleStream.class, DISTINCT_FUNCTION, new Object[0]);
    private static final Function<DoubleStream, Stream<Double>> BOXED_FUNCTION = DoubleStream::boxed;
    private static final IntermediateOperation<DoubleStream, Stream<Double>> BOXED = new StandardIntermediateOperation<DoubleStream, Stream<Double>>(IntermediateOperationType.BOXED, DoubleStream.class, Stream.class, BOXED_FUNCTION, new Object[0]);

    public IntermediateOperation<DoubleStream, DoubleStream> createFilter(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.filter(predicate);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.FILTER, DoubleStream.class, DoubleStream.class, function, predicate);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> createMap(DoubleUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        UnaryOperator function = s -> s.map(mapper);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.MAP_TO_SAME, DoubleStream.class, DoubleStream.class, function, mapper);
    }

    public <U> IntermediateOperation<DoubleStream, Stream<U>> createMapToObj(DoubleFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        Function<DoubleStream, Stream> function = s -> s.mapToObj(mapper);
        return new StandardIntermediateOperation<DoubleStream, Stream<U>>(IntermediateOperationType.MAP_TO, DoubleStream.class, Stream.class, function, mapper);
    }

    public IntermediateOperation<DoubleStream, LongStream> createMapToLong(DoubleToLongFunction mapper) {
        Objects.requireNonNull(mapper);
        Function<DoubleStream, LongStream> function = s -> s.mapToLong(mapper);
        return new StandardIntermediateOperation<DoubleStream, LongStream>(IntermediateOperationType.MAP_TO, DoubleStream.class, LongStream.class, function, mapper);
    }

    public IntermediateOperation<DoubleStream, IntStream> createMapToInt(DoubleToIntFunction mapper) {
        Objects.requireNonNull(mapper);
        Function<DoubleStream, IntStream> function = s -> s.mapToInt(mapper);
        return new StandardIntermediateOperation<DoubleStream, IntStream>(IntermediateOperationType.MAP_TO, DoubleStream.class, IntStream.class, function, mapper);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> createFlatMap(DoubleFunction<? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        UnaryOperator function = s -> s.flatMap(mapper);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.FLAT_MAP_TO_SAME, DoubleStream.class, DoubleStream.class, function, mapper);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> acquireDistinct() {
        return TypeUtil.typed(DISTINCT);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> acquireSorted() {
        return TypeUtil.typed(SORTED);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> createPeek(DoubleConsumer action) {
        Objects.requireNonNull(action);
        UnaryOperator function = s -> s.peek(action);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.PEEK, DoubleStream.class, DoubleStream.class, function, action);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> createLimit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        UnaryOperator function = s -> s.limit(maxSize);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.LIMIT, DoubleStream.class, DoubleStream.class, function, maxSize);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> createSkip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        UnaryOperator function = s -> s.skip(n);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.SKIP, DoubleStream.class, DoubleStream.class, function, n);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> createTakeWhile(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> Java9StreamUtil.takeWhile((DoubleStream)s, (DoublePredicate)predicate);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.TAKE_WHILE, DoubleStream.class, DoubleStream.class, function, predicate);
    }

    public IntermediateOperation<DoubleStream, DoubleStream> createDropWhile(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> Java9StreamUtil.dropWhile((DoubleStream)s, (DoublePredicate)predicate);
        return new StandardIntermediateOperation<DoubleStream, DoubleStream>(IntermediateOperationType.DROP_WHILE, DoubleStream.class, DoubleStream.class, function, predicate);
    }

    public IntermediateOperation<DoubleStream, Stream<Double>> acquireBoxed() {
        return BOXED;
    }
}

