/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.standard.internal.terminal;

import com.speedment.jpastreamer.pipeline.standard.internal.terminal.AcceptTerminalOperation;
import com.speedment.jpastreamer.pipeline.standard.internal.terminal.ApplyAsDoubleTerminalOperation;
import com.speedment.jpastreamer.pipeline.standard.internal.terminal.ApplyAsLongTerminalOperation;
import com.speedment.jpastreamer.pipeline.standard.internal.terminal.ApplyTerminalOperation;
import com.speedment.jpastreamer.pipeline.standard.internal.terminal.TestTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.DoubleTerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationType;
import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.DoubleStream;

public class InternalDoubleTerminalOperationFactory
implements DoubleTerminalOperationFactory {
    private static final TerminalOperation<DoubleStream, double[]> TO_ARRAY = new ApplyTerminalOperation<DoubleStream, double[], Function<DoubleStream, double[]>>(TerminalOperationType.TO_ARRAY, DoubleStream.class, double[].class, DoubleStream::toArray, new Object[0]);
    private static final TerminalOperation<DoubleStream, Double> SUM = new ApplyAsDoubleTerminalOperation<DoubleStream, Double, ToDoubleFunction<DoubleStream>>(TerminalOperationType.SUM_DOUBLE, DoubleStream.class, Double.TYPE, DoubleStream::sum, new Object[0]);
    private static final TerminalOperation<DoubleStream, OptionalDouble> MIN = new ApplyTerminalOperation<DoubleStream, OptionalDouble, Function<DoubleStream, OptionalDouble>>(TerminalOperationType.MIN, DoubleStream.class, OptionalDouble.class, DoubleStream::min, new Object[0]);
    private static final TerminalOperation<DoubleStream, OptionalDouble> MAX = new ApplyTerminalOperation<DoubleStream, OptionalDouble, Function<DoubleStream, OptionalDouble>>(TerminalOperationType.MAX, DoubleStream.class, OptionalDouble.class, DoubleStream::max, new Object[0]);
    private static final TerminalOperation<DoubleStream, OptionalDouble> AVERAGE = new ApplyTerminalOperation<DoubleStream, OptionalDouble, Function<DoubleStream, OptionalDouble>>(TerminalOperationType.MAX, DoubleStream.class, OptionalDouble.class, DoubleStream::average, new Object[0]);
    private static final TerminalOperation<DoubleStream, DoubleSummaryStatistics> SUMMARY_STATISTICS = new ApplyTerminalOperation<DoubleStream, DoubleSummaryStatistics, Function<DoubleStream, DoubleSummaryStatistics>>(TerminalOperationType.MAX, DoubleStream.class, DoubleSummaryStatistics.class, DoubleStream::summaryStatistics, new Object[0]);
    private static final TerminalOperation<DoubleStream, OptionalDouble> FIND_FIRST = new ApplyTerminalOperation<DoubleStream, OptionalDouble, Function<DoubleStream, OptionalDouble>>(TerminalOperationType.FIND_FIRST, DoubleStream.class, OptionalDouble.class, DoubleStream::findFirst, new Object[0]);
    private static final TerminalOperation<DoubleStream, OptionalDouble> FIND_ANY = new ApplyTerminalOperation<DoubleStream, OptionalDouble, Function<DoubleStream, OptionalDouble>>(TerminalOperationType.FIND_ANY, DoubleStream.class, OptionalDouble.class, DoubleStream::findAny, new Object[0]);
    private static final TerminalOperation<DoubleStream, Long> COUNT = new ApplyAsLongTerminalOperation<DoubleStream, Long, ToLongFunction<DoubleStream>>(TerminalOperationType.COUNT, DoubleStream.class, Long.TYPE, DoubleStream::count, new Object[0]);
    private static final TerminalOperation<DoubleStream, PrimitiveIterator.OfDouble> ITERATOR = new ApplyTerminalOperation<DoubleStream, PrimitiveIterator.OfDouble, Function<DoubleStream, PrimitiveIterator.OfDouble>>(TerminalOperationType.ITERATOR, DoubleStream.class, PrimitiveIterator.OfDouble.class, DoubleStream::iterator, new Object[0]);
    private static final TerminalOperation<DoubleStream, Spliterator.OfDouble> SPLITERATOR = new ApplyTerminalOperation<DoubleStream, Spliterator.OfDouble, Function<DoubleStream, Spliterator.OfDouble>>(TerminalOperationType.SPLITERATOR, DoubleStream.class, Spliterator.OfDouble.class, DoubleStream::spliterator, new Object[0]);

    public TerminalOperation<DoubleStream, Void> createForEach(DoubleConsumer action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<DoubleStream, Void, Consumer<DoubleStream>>(TerminalOperationType.FOR_EACH, DoubleStream.class, Void.TYPE, stream -> stream.forEach(action), action);
    }

    public TerminalOperation<DoubleStream, Void> createForEachOrdered(DoubleConsumer action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<DoubleStream, Void, Consumer<DoubleStream>>(TerminalOperationType.FOR_EACH_ORDERED, DoubleStream.class, Void.TYPE, stream -> stream.forEachOrdered(action), action);
    }

    public TerminalOperation<DoubleStream, double[]> acquireToArray() {
        return TO_ARRAY;
    }

    public TerminalOperation<DoubleStream, Double> createReduce(double identity, DoubleBinaryOperator op) {
        Objects.requireNonNull(op);
        return new ApplyAsDoubleTerminalOperation<DoubleStream, Double, ToDoubleFunction<DoubleStream>>(TerminalOperationType.REDUCE, DoubleStream.class, Double.TYPE, stream -> stream.reduce(identity, op), identity, op);
    }

    public TerminalOperation<DoubleStream, OptionalDouble> createReduce(DoubleBinaryOperator op) {
        Objects.requireNonNull(op);
        return new ApplyTerminalOperation<DoubleStream, OptionalDouble, Function<DoubleStream, OptionalDouble>>(TerminalOperationType.REDUCE, DoubleStream.class, OptionalDouble.class, stream -> stream.reduce(op), op);
    }

    public <R> TerminalOperation<DoubleStream, R> createCollect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ApplyTerminalOperation<DoubleStream, Object, Function<DoubleStream, Object>>(TerminalOperationType.COLLECT, DoubleStream.class, Object.class, stream -> stream.collect(supplier, accumulator, combiner), supplier, accumulator, combiner);
    }

    public TerminalOperation<DoubleStream, Double> acquireSum() {
        return SUM;
    }

    public TerminalOperation<DoubleStream, OptionalDouble> acquireMin() {
        return MIN;
    }

    public TerminalOperation<DoubleStream, OptionalDouble> acquireMax() {
        return MAX;
    }

    public TerminalOperation<DoubleStream, Long> acquireCount() {
        return COUNT;
    }

    public TerminalOperation<DoubleStream, OptionalDouble> acquireAverage() {
        return AVERAGE;
    }

    public TerminalOperation<DoubleStream, DoubleSummaryStatistics> acquireSummaryStatistics() {
        return SUMMARY_STATISTICS;
    }

    public TerminalOperation<DoubleStream, Boolean> createAnyMatch(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<DoubleStream, Boolean, Predicate<DoubleStream>>(TerminalOperationType.ANY_MATCH, DoubleStream.class, Boolean.TYPE, stream -> stream.anyMatch(predicate), predicate);
    }

    public TerminalOperation<DoubleStream, Boolean> createAllMatch(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<DoubleStream, Boolean, Predicate<DoubleStream>>(TerminalOperationType.ALL_MATCH, DoubleStream.class, Boolean.TYPE, stream -> stream.allMatch(predicate), predicate);
    }

    public TerminalOperation<DoubleStream, Boolean> createNoneMatch(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<DoubleStream, Boolean, Predicate<DoubleStream>>(TerminalOperationType.NONE_MATCH, DoubleStream.class, Boolean.TYPE, stream -> stream.noneMatch(predicate), predicate);
    }

    public TerminalOperation<DoubleStream, OptionalDouble> acquireFindFirst() {
        return FIND_FIRST;
    }

    public TerminalOperation<DoubleStream, OptionalDouble> acquireFindAny() {
        return FIND_ANY;
    }

    public TerminalOperation<DoubleStream, PrimitiveIterator.OfDouble> acquireIterator() {
        return ITERATOR;
    }

    public TerminalOperation<DoubleStream, Spliterator.OfDouble> acquireSpliterator() {
        return SPLITERATOR;
    }
}

