/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.terminal.standard.internal;

import com.speedment.jpastreamer.pipeline.terminal.IntTerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationType;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.AcceptTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.ApplyAsIntTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.ApplyAsLongTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.ApplyTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.TestTerminalOperation;
import java.util.IntSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.IntStream;

public class InternalIntTerminalOperationFactory
implements IntTerminalOperationFactory {
    private static final TerminalOperation<IntStream, int[]> TO_ARRAY = new ApplyTerminalOperation<IntStream, int[], Function<IntStream, int[]>>(TerminalOperationType.TO_ARRAY, IntStream.class, int[].class, IntStream::toArray, new Object[0]);
    private static final TerminalOperation<IntStream, Integer> SUM = new ApplyAsIntTerminalOperation<IntStream, Integer, ToIntFunction<IntStream>>(TerminalOperationType.SUM_INT, IntStream.class, Integer.TYPE, IntStream::sum, new Object[0]);
    private static final TerminalOperation<IntStream, OptionalInt> MIN = new ApplyTerminalOperation<IntStream, OptionalInt, Function<IntStream, OptionalInt>>(TerminalOperationType.MIN, IntStream.class, OptionalInt.class, IntStream::min, new Object[0]);
    private static final TerminalOperation<IntStream, OptionalInt> MAX = new ApplyTerminalOperation<IntStream, OptionalInt, Function<IntStream, OptionalInt>>(TerminalOperationType.MAX, IntStream.class, OptionalInt.class, IntStream::max, new Object[0]);
    private static final TerminalOperation<IntStream, OptionalDouble> AVERAGE = new ApplyTerminalOperation<IntStream, OptionalDouble, Function<IntStream, OptionalDouble>>(TerminalOperationType.MAX, IntStream.class, OptionalDouble.class, IntStream::average, new Object[0]);
    private static final TerminalOperation<IntStream, IntSummaryStatistics> SUMMARY_STATISTICS = new ApplyTerminalOperation<IntStream, IntSummaryStatistics, Function<IntStream, IntSummaryStatistics>>(TerminalOperationType.MAX, IntStream.class, IntSummaryStatistics.class, IntStream::summaryStatistics, new Object[0]);
    private static final TerminalOperation<IntStream, OptionalInt> FIND_FIRST = new ApplyTerminalOperation<IntStream, OptionalInt, Function<IntStream, OptionalInt>>(TerminalOperationType.FIND_FIRST, IntStream.class, OptionalInt.class, IntStream::findFirst, new Object[0]);
    private static final TerminalOperation<IntStream, OptionalInt> FIND_ANY = new ApplyTerminalOperation<IntStream, OptionalInt, Function<IntStream, OptionalInt>>(TerminalOperationType.FIND_ANY, IntStream.class, OptionalInt.class, IntStream::findAny, new Object[0]);
    private static final TerminalOperation<IntStream, Long> COUNT = new ApplyAsLongTerminalOperation<IntStream, Long, ToLongFunction<IntStream>>(TerminalOperationType.COUNT, IntStream.class, Long.TYPE, IntStream::count, new Object[0]);
    private static final TerminalOperation<IntStream, PrimitiveIterator.OfInt> ITERATOR = new ApplyTerminalOperation<IntStream, PrimitiveIterator.OfInt, Function<IntStream, PrimitiveIterator.OfInt>>(TerminalOperationType.ITERATOR, IntStream.class, PrimitiveIterator.OfInt.class, IntStream::iterator, new Object[0]);
    private static final TerminalOperation<IntStream, Spliterator.OfInt> SPLITERATOR = new ApplyTerminalOperation<IntStream, Spliterator.OfInt, Function<IntStream, Spliterator.OfInt>>(TerminalOperationType.SPLITERATOR, IntStream.class, Spliterator.OfInt.class, IntStream::spliterator, new Object[0]);

    public TerminalOperation<IntStream, Void> createForEach(IntConsumer action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<IntStream, Void, Consumer<IntStream>>(TerminalOperationType.FOR_EACH, IntStream.class, Void.TYPE, stream -> stream.forEach(action), action);
    }

    public TerminalOperation<IntStream, Void> createForEachOrdered(IntConsumer action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<IntStream, Void, Consumer<IntStream>>(TerminalOperationType.FOR_EACH_ORDERED, IntStream.class, Void.TYPE, stream -> stream.forEachOrdered(action), action);
    }

    public TerminalOperation<IntStream, int[]> acquireToArray() {
        return TO_ARRAY;
    }

    public TerminalOperation<IntStream, Integer> createReduce(int identity, IntBinaryOperator op) {
        Objects.requireNonNull(op);
        return new ApplyAsIntTerminalOperation<IntStream, Integer, ToIntFunction<IntStream>>(TerminalOperationType.REDUCE, IntStream.class, Integer.TYPE, stream -> stream.reduce(identity, op), identity, op);
    }

    public TerminalOperation<IntStream, OptionalInt> createReduce(IntBinaryOperator op) {
        Objects.requireNonNull(op);
        return new ApplyTerminalOperation<IntStream, OptionalInt, Function<IntStream, OptionalInt>>(TerminalOperationType.REDUCE, IntStream.class, OptionalInt.class, stream -> stream.reduce(op), op);
    }

    public <R> TerminalOperation<IntStream, R> createCollect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ApplyTerminalOperation<IntStream, Object, Function<IntStream, Object>>(TerminalOperationType.COLLECT, IntStream.class, Object.class, stream -> stream.collect(supplier, accumulator, combiner), supplier, accumulator, combiner);
    }

    public TerminalOperation<IntStream, Integer> acquireSum() {
        return SUM;
    }

    public TerminalOperation<IntStream, OptionalInt> acquireMin() {
        return MIN;
    }

    public TerminalOperation<IntStream, OptionalInt> acquireMax() {
        return MAX;
    }

    public TerminalOperation<IntStream, Long> acquireCount() {
        return COUNT;
    }

    public TerminalOperation<IntStream, OptionalDouble> acquireAverage() {
        return AVERAGE;
    }

    public TerminalOperation<IntStream, IntSummaryStatistics> acquireSummaryStatistics() {
        return SUMMARY_STATISTICS;
    }

    public TerminalOperation<IntStream, Boolean> createAnyMatch(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<IntStream, Boolean, Predicate<IntStream>>(TerminalOperationType.ANY_MATCH, IntStream.class, Boolean.TYPE, stream -> stream.anyMatch(predicate), predicate);
    }

    public TerminalOperation<IntStream, Boolean> createAllMatch(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<IntStream, Boolean, Predicate<IntStream>>(TerminalOperationType.ALL_MATCH, IntStream.class, Boolean.TYPE, stream -> stream.allMatch(predicate), predicate);
    }

    public TerminalOperation<IntStream, Boolean> createNoneMatch(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<IntStream, Boolean, Predicate<IntStream>>(TerminalOperationType.NONE_MATCH, IntStream.class, Boolean.TYPE, stream -> stream.noneMatch(predicate), predicate);
    }

    public TerminalOperation<IntStream, OptionalInt> acquireFindFirst() {
        return FIND_FIRST;
    }

    public TerminalOperation<IntStream, OptionalInt> acquireFindAny() {
        return FIND_ANY;
    }

    public TerminalOperation<IntStream, PrimitiveIterator.OfInt> acquireIterator() {
        return ITERATOR;
    }

    public TerminalOperation<IntStream, Spliterator.OfInt> acquireSpliterator() {
        return SPLITERATOR;
    }
}

