/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.terminal.standard.internal;

import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationType;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractTerminalOperation<S extends BaseStream<?, S>, R>
implements TerminalOperation<S, R> {
    private final TerminalOperationType type;
    private final Class<? super S> streamType;
    private final Class<? super R> returnType;
    private final Object[] arguments;

    AbstractTerminalOperation(TerminalOperationType type, Class<? super S> streamType, Class<? super R> returnType, Object ... arguments) {
        this.type = Objects.requireNonNull(type);
        this.streamType = Objects.requireNonNull(streamType);
        this.arguments = Objects.requireNonNull(arguments);
        this.returnType = Objects.requireNonNull(returnType);
    }

    public TerminalOperationType type() {
        return this.type;
    }

    public Class<? super S> streamType() {
        return this.streamType;
    }

    public Object[] arguments() {
        return this.arguments;
    }

    public Class<? super R> returnType() {
        return this.returnType;
    }

    public Function<S, R> function() {
        throw this.newClassCastException("function");
    }

    public ToLongFunction<S> toLongFunction() {
        throw this.newClassCastException("toLongFunction");
    }

    public ToIntFunction<S> toIntFunction() {
        throw this.newClassCastException("toIntFunction");
    }

    public ToDoubleFunction<S> toDoubleFunction() {
        throw this.newClassCastException("toDoubleFunction");
    }

    public Predicate<S> predicate() {
        throw this.newClassCastException("predicate");
    }

    public Consumer<S> consumer() {
        throw this.newClassCastException("consumer");
    }

    public String toString() {
        return String.format("%s(%s)", this.type.toString(), this.arguments == null ? "" : Stream.of(this.arguments).map(this::objectLabel).collect(Collectors.joining(", ")));
    }

    private String objectLabel(Object object) {
        if (object instanceof Long) {
            return object.toString();
        }
        return object.getClass().getSimpleName();
    }

    private ClassCastException newClassCastException(String methodName) {
        throw new ClassCastException("Unable to apply " + methodName + "() because a terminal operation of type " + this.type + " does not have a " + methodName + "()");
    }
}

