/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.terminal;

import com.speedment.jpastreamer.pipeline.terminal.OrderPreservation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationFunctionalType;
import java.util.Objects;

public enum TerminalOperationType {
    ITERATOR(TerminalOperationFunctionalType.APPLY, OrderPreservation.REQUIRED),
    SPLITERATOR(TerminalOperationFunctionalType.APPLY, OrderPreservation.REQUIRED),
    FOR_EACH(TerminalOperationFunctionalType.ACCEPT, OrderPreservation.NOT_REQUIRED),
    FOR_EACH_ORDERED(TerminalOperationFunctionalType.ACCEPT, OrderPreservation.REQUIRED),
    TO_ARRAY(TerminalOperationFunctionalType.APPLY, OrderPreservation.REQUIRED),
    REDUCE(TerminalOperationFunctionalType.APPLY, OrderPreservation.NOT_REQUIRED_IF_PARALLEL),
    COLLECT(TerminalOperationFunctionalType.APPLY, OrderPreservation.NOT_REQUIRED_IF_PARALLEL),
    MIN(TerminalOperationFunctionalType.APPLY, OrderPreservation.NOT_REQUIRED),
    MAX(TerminalOperationFunctionalType.APPLY, OrderPreservation.NOT_REQUIRED),
    COUNT(TerminalOperationFunctionalType.APPLY_AS_LONG, OrderPreservation.NOT_REQUIRED),
    ANY_MATCH(TerminalOperationFunctionalType.TEST, OrderPreservation.NOT_REQUIRED),
    ALL_MATCH(TerminalOperationFunctionalType.TEST, OrderPreservation.NOT_REQUIRED),
    NONE_MATCH(TerminalOperationFunctionalType.TEST, OrderPreservation.NOT_REQUIRED),
    FIND_FIRST(TerminalOperationFunctionalType.APPLY, OrderPreservation.REQUIRED),
    FIND_ANY(TerminalOperationFunctionalType.APPLY, OrderPreservation.NOT_REQUIRED),
    SUM_INT(TerminalOperationFunctionalType.APPLY_AS_INT, OrderPreservation.NOT_REQUIRED),
    SUM_LONG(TerminalOperationFunctionalType.APPLY_AS_LONG, OrderPreservation.NOT_REQUIRED),
    SUM_DOUBLE(TerminalOperationFunctionalType.APPLY_AS_DOUBLE, OrderPreservation.NOT_REQUIRED),
    AVERAGE(TerminalOperationFunctionalType.APPLY, OrderPreservation.NOT_REQUIRED),
    SUMMARY_STATISTICS(TerminalOperationFunctionalType.APPLY, OrderPreservation.NOT_REQUIRED);

    private final TerminalOperationFunctionalType functionalType;
    private final OrderPreservation orderPreservation;

    private TerminalOperationType(TerminalOperationFunctionalType functionalType, OrderPreservation orderPreservation) {
        this.functionalType = Objects.requireNonNull(functionalType);
        this.orderPreservation = Objects.requireNonNull(orderPreservation);
    }

    public TerminalOperationFunctionalType functionalType() {
        return this.functionalType;
    }

    public OrderPreservation orderPreservation() {
        return this.orderPreservation;
    }
}

