/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.intermediate;

import com.speedment.jpastreamer.pipeline.intermediate.Statement;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IntermediateOperationType {
    FILTER(Statement.PRESERVES_ORDER, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE),
    DISTINCT(Statement.PRESERVES_ORDER, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE),
    FLAT_MAP(Statement.PRESERVES_ORDER, Statement.PRESERVES_STREAM_TYPE),
    FLAT_MAP_TO(Statement.PRESERVES_ORDER, Statement.MODIFIES_STREAM_TYPE),
    FLAT_MAP_TO_SAME(Statement.PRESERVES_ORDER, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE),
    LIMIT(Statement.PRESERVES_ORDER, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE, Statement.MODIFIES_FINITE),
    MAP(Statement.PRESERVES_ORDER, Statement.PRESERVES_SIZE, Statement.PRESERVES_STREAM_TYPE),
    MAP_TO_SAME(Statement.PRESERVES_ORDER, Statement.PRESERVES_SIZE, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE),
    MAP_TO(Statement.PRESERVES_ORDER, Statement.PRESERVES_SIZE, Statement.MODIFIES_STREAM_TYPE),
    PEEK(Statement.PRESERVES_ORDER, Statement.PRESERVES_SIZE, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE, Statement.MODIFIES_SIDE_EFFECT),
    SKIP(Statement.PRESERVES_ORDER, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE),
    SORTED(Statement.MODIFIES_ORDER, Statement.PRESERVES_SIZE, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE, Statement.MODIFIES_SORTED),
    BOXED(Statement.PRESERVES_ORDER, Statement.PRESERVES_SIZE, Statement.MODIFIES_STREAM_TYPE),
    AS(Statement.PRESERVES_ORDER, Statement.PRESERVES_SIZE, Statement.MODIFIES_STREAM_TYPE),
    TAKE_WHILE(Statement.PRESERVES_ORDER, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE),
    DROP_WHILE(Statement.PRESERVES_ORDER, Statement.PRESERVES_TYPE, Statement.PRESERVES_STREAM_TYPE);

    private final Set<Statement> orderPreservation;

    private IntermediateOperationType(Statement ... statements) {
        this.orderPreservation = statements.length == 0 ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(Stream.of(statements).collect(Collectors.toSet())));
    }

    public Set<Statement> statements() {
        return this.orderPreservation;
    }
}

