/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.projection;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.projection.internal.InternalProjection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.Tuple;

public interface Projection<ENTITY>
extends Function<ENTITY, Tuple> {
    public Class<ENTITY> entityClass();

    public Set<Field<ENTITY>> fields();

    @SafeVarargs
    public static <ENTITY> Projection<ENTITY> select(Field<ENTITY> first, Field<ENTITY> ... other) {
        Objects.requireNonNull(first);
        Class entityClass = first.table();
        LinkedHashSet fields = new LinkedHashSet();
        fields.add(first);
        if (other != null) {
            Collections.addAll(fields, other);
        }
        return new InternalProjection(entityClass, fields);
    }
}

