/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.projection.internal;

import jakarta.persistence.TupleElement;
import java.util.Objects;

final class StandardTupleElement<X>
implements TupleElement<X> {
    private final Class<? extends X> javaType;
    private final String alias;

    public StandardTupleElement(Class<? extends X> javaType, String alias) {
        this.javaType = Objects.requireNonNull(javaType);
        this.alias = alias;
    }

    public Class<? extends X> getJavaType() {
        return this.javaType;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardTupleElement that = (StandardTupleElement)o;
        if (!this.javaType.equals(that.javaType)) {
            return false;
        }
        return Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        int result = this.javaType.hashCode();
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StandardTupleElement{javaType=" + String.valueOf(this.javaType) + ", alias='" + this.alias + "'}";
    }
}

