/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.renderer.standard.internal;

import com.speedment.jpastreamer.criteria.Criteria;
import com.speedment.jpastreamer.criteria.CriteriaFactory;
import com.speedment.jpastreamer.interopoptimizer.IntermediateOperationOptimizerFactory;
import com.speedment.jpastreamer.merger.CriteriaMerger;
import com.speedment.jpastreamer.merger.MergerFactory;
import com.speedment.jpastreamer.merger.QueryMerger;
import com.speedment.jpastreamer.pipeline.Pipeline;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationType;
import com.speedment.jpastreamer.projection.Projection;
import com.speedment.jpastreamer.renderer.RenderResult;
import com.speedment.jpastreamer.renderer.Renderer;
import com.speedment.jpastreamer.renderer.standard.internal.StandardRenderResult;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Selection;

final class StandardRenderer
implements Renderer {
    private final EntityManager entityManager;
    private final CriteriaFactory criteriaFactory;
    private final IntermediateOperationOptimizerFactory intermediateOperationOptimizerFactory;
    private final MergerFactory mergerFactory;

    StandardRenderer(EntityManagerFactory entityManagerFactory) {
        this(() -> ((EntityManagerFactory)entityManagerFactory).createEntityManager());
    }

    StandardRenderer(Supplier<EntityManager> entityManagerSupplier) {
        this.entityManager = Objects.requireNonNull(entityManagerSupplier).get();
        this.criteriaFactory = (CriteriaFactory)RootFactory.getOrThrow(CriteriaFactory.class, ServiceLoader::load);
        this.intermediateOperationOptimizerFactory = (IntermediateOperationOptimizerFactory)RootFactory.getOrThrow(IntermediateOperationOptimizerFactory.class, ServiceLoader::load);
        this.mergerFactory = (MergerFactory)RootFactory.getOrThrow(MergerFactory.class, ServiceLoader::load);
    }

    StandardRenderer(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.criteriaFactory = (CriteriaFactory)RootFactory.getOrThrow(CriteriaFactory.class, ServiceLoader::load);
        this.intermediateOperationOptimizerFactory = (IntermediateOperationOptimizerFactory)RootFactory.getOrThrow(IntermediateOperationOptimizerFactory.class, ServiceLoader::load);
        this.mergerFactory = (MergerFactory)RootFactory.getOrThrow(MergerFactory.class, ServiceLoader::load);
    }

    public <E, T, S extends BaseStream<T, S>> RenderResult<E, T, S> render(Pipeline<E> pipeline, StreamConfiguration<E> streamConfiguration) {
        this.optimizePipeline(pipeline);
        Class entityClass = pipeline.root();
        CriteriaMerger criteriaMerger = this.mergerFactory.createCriteriaMerger();
        QueryMerger queryMerger = this.mergerFactory.createQueryMerger();
        Criteria criteria = this.criteriaFactory.createCriteria(this.entityManager, entityClass);
        criteria.getRoot().alias(pipeline.root().getSimpleName());
        Optional oSelections = streamConfiguration.selections();
        if (oSelections.isPresent()) {
            Projection projection = (Projection)oSelections.get();
            Path[] columns = (Path[])projection.fields().stream().map(field -> criteria.getRoot().get(field.columnName())).toArray(Path[]::new);
            CompoundSelection selection = criteria.getBuilder().construct(projection.entityClass(), (Selection[])columns);
            criteria.getQuery().select((Selection)selection);
        } else {
            criteria.getQuery().select((Selection)criteria.getRoot());
        }
        streamConfiguration.joins().forEach(joinConfiguration -> criteria.getRoot().fetch(joinConfiguration.field().columnName(), joinConfiguration.joinType()));
        criteriaMerger.merge(pipeline, criteria);
        if (pipeline.terminatingOperation().type() == TerminalOperationType.COUNT && pipeline.intermediateOperations().isEmpty()) {
            Criteria<T, Long> countCriteria = this.createCountCriteria(criteria);
            TypedQuery typedQuery = this.entityManager.createQuery(countCriteria.getQuery());
            countCriteria.getQueryParameters().forEach(queryParameter -> typedQuery.setParameter((Parameter)queryParameter.getParameterExpression(), queryParameter.getValue()));
            return new StandardRenderResult(entityClass, typedQuery.getResultStream(), pipeline.terminatingOperation());
        }
        TypedQuery typedQuery = this.entityManager.createQuery(criteria.getQuery());
        criteria.getQueryParameters().forEach(queryParameter -> typedQuery.setParameter((Parameter)queryParameter.getParameterExpression(), queryParameter.getValue()));
        queryMerger.merge(pipeline, (Query)typedQuery);
        Stream baseStream = typedQuery.getResultStream();
        S replayed = this.replay(baseStream, pipeline);
        return new StandardRenderResult(entityClass, replayed, pipeline.terminatingOperation());
    }

    private <T> Criteria<T, Long> createCountCriteria(Criteria<T, T> criteria) {
        CriteriaQuery criteriaQuery = criteria.getQuery();
        Criteria countCriteria = this.criteriaFactory.createCriteria(this.entityManager, criteriaQuery.getResultType(), Long.class);
        criteria.getQueryParameters().forEach(arg_0 -> ((Criteria)countCriteria).addQueryParameter(arg_0));
        countCriteria.getRoot().alias(criteria.getRoot().getAlias());
        CriteriaQuery countQuery = countCriteria.getQuery();
        countQuery.select((Selection)countCriteria.getBuilder().count((Expression)countCriteria.getRoot()));
        if (criteriaQuery.getRestriction() != null) {
            countQuery.where((Expression)criteriaQuery.getRestriction());
        }
        countQuery.distinct(criteriaQuery.isDistinct());
        countQuery.orderBy(criteria.getQuery().getOrderList());
        return countCriteria;
    }

    private <E, T, S extends BaseStream<T, S>> S replay(Stream<E> stream, Pipeline<E> pipeline) {
        return (S)((Stream)pipeline.intermediateOperations().stream().sequential()).reduce(stream, (s, io) -> (BaseStream)io.function().apply(s), (a, b) -> a);
    }

    private <T> void optimizePipeline(Pipeline<T> pipeline) {
        this.intermediateOperationOptimizerFactory.stream().forEach(intermediateOperationOptimizer -> intermediateOperationOptimizer.optimize(pipeline));
    }

    public void close() {
        this.entityManager.close();
    }
}

