/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.streamconfiguration.standard.internal;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.projection.Projection;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import com.speedment.jpastreamer.streamconfiguration.standard.internal.StandardJoinConfiguration;
import jakarta.persistence.criteria.JoinType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class StandardStreamConfiguration<T>
implements StreamConfiguration<T> {
    private final Class<T> entityClass;
    private final Projection<T> projection;
    private final Set<StreamConfiguration.JoinConfiguration<T>> joinConfigurations;
    private final Map<String, Object> queryHints;

    public StandardStreamConfiguration(Class<T> entityClass) {
        this.entityClass = Objects.requireNonNull(entityClass);
        this.projection = null;
        this.joinConfigurations = Collections.emptySet();
        this.queryHints = Collections.emptyMap();
    }

    private StandardStreamConfiguration(Class<T> entityClass, Projection<T> projection, Set<StreamConfiguration.JoinConfiguration<T>> joinConfigurations, Map<String, Object> queryHints) {
        this.entityClass = entityClass;
        this.projection = projection;
        this.joinConfigurations = new HashSet<StreamConfiguration.JoinConfiguration<T>>(joinConfigurations);
        this.queryHints = new HashMap<String, Object>(queryHints);
    }

    public Class<T> entityClass() {
        return this.entityClass;
    }

    public Set<StreamConfiguration.JoinConfiguration<T>> joins() {
        return Collections.unmodifiableSet(this.joinConfigurations);
    }

    public StreamConfiguration<T> joining(Field<T> field, JoinType joinType) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(joinType);
        HashSet<StreamConfiguration.JoinConfiguration<T>> newJoins = new HashSet<StreamConfiguration.JoinConfiguration<T>>(this.joinConfigurations);
        newJoins.add(new StandardJoinConfiguration<T>(field, joinType));
        return new StandardStreamConfiguration<T>(this.entityClass, this.projection, newJoins, this.queryHints);
    }

    public Optional<Projection<T>> selections() {
        return Optional.ofNullable(this.projection);
    }

    public StreamConfiguration<T> selecting(Projection<T> projection) {
        Objects.requireNonNull(projection);
        return new StandardStreamConfiguration<T>(this.entityClass, projection, this.joinConfigurations, this.queryHints);
    }

    public Map<String, Object> hints() {
        return Collections.unmodifiableMap(this.queryHints);
    }

    public StreamConfiguration<T> withHint(String hintName, Object value) {
        Objects.requireNonNull(hintName);
        Objects.requireNonNull(value);
        HashMap<String, Object> newHints = new HashMap<String, Object>(this.queryHints);
        newHints.put(hintName, value);
        return new StandardStreamConfiguration<T>(this.entityClass, this.projection, this.joinConfigurations, newHints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardStreamConfiguration that = (StandardStreamConfiguration)o;
        if (!this.entityClass.equals(that.entityClass)) {
            return false;
        }
        return this.joinConfigurations.equals(that.joinConfigurations);
    }

    public int hashCode() {
        int result = this.entityClass.hashCode();
        result = 31 * result + this.joinConfigurations.hashCode();
        return result;
    }

    public String toString() {
        String joinText = this.joinConfigurations.isEmpty() ? "" : " joining " + this.joinConfigurations.stream().map(Object::toString).sorted().collect(Collectors.joining(", "));
        return "StandardStreamConfiguration{of " + this.entityClass.getSimpleName() + joinText + "}";
    }
}

