/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.streamconfiguration.standard.internal;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import jakarta.persistence.criteria.JoinType;
import java.util.Objects;

final class StandardJoinConfiguration<T>
implements StreamConfiguration.JoinConfiguration<T> {
    private final Field<T> field;
    private final JoinType joinType;

    StandardJoinConfiguration(Field<T> field, JoinType joinType) {
        this.field = Objects.requireNonNull(field);
        this.joinType = Objects.requireNonNull(joinType);
    }

    public Field<T> field() {
        return this.field;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardJoinConfiguration that = (StandardJoinConfiguration)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.joinType == that.joinType;
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.joinType.hashCode();
        return result;
    }

    public String toString() {
        return StandardJoinConfiguration.label(this.joinType) + " on " + this.field.columnName();
    }

    private static String label(JoinType joinType) {
        switch (joinType) {
            case INNER: {
                return "inner join";
            }
            case LEFT: {
                return "left outer join";
            }
            case RIGHT: {
                return "right outer join";
            }
        }
        return joinType.name();
    }
}

