/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.streamconfiguration;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.projection.Projection;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfigurationFactory;
import jakarta.persistence.criteria.JoinType;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;

public interface StreamConfiguration<T> {
    public Class<T> entityClass();

    public Set<JoinConfiguration<T>> joins();

    default public StreamConfiguration<T> joining(Field<T> field) {
        return this.joining(field, JoinType.LEFT);
    }

    public StreamConfiguration<T> joining(Field<T> var1, JoinType var2);

    public Optional<Projection<T>> selections();

    public StreamConfiguration<T> selecting(Projection<T> var1);

    public static <T> StreamConfiguration<T> of(Class<T> entityClass) {
        return ((StreamConfigurationFactory)RootFactory.getOrThrow(StreamConfigurationFactory.class, ServiceLoader::load)).createStreamConfiguration(entityClass);
    }

    public static interface JoinConfiguration<T> {
        public Field<T> field();

        public JoinType joinType();
    }
}

