/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.application;

import com.speedment.common.injector.InjectBundle;
import com.speedment.common.injector.Injector;
import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.injector.exception.CyclicReferenceException;
import com.speedment.common.injector.execution.ExecutionBuilder;
import com.speedment.common.invariant.NullUtil;
import com.speedment.common.jvm_version.JvmVersion;
import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import com.speedment.runtime.application.RuntimeBundle;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.config.util.DocumentUtil;
import com.speedment.runtime.core.ApplicationBuilder;
import com.speedment.runtime.core.ApplicationMetadata;
import com.speedment.runtime.core.Speedment;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.component.InfoComponent;
import com.speedment.runtime.core.component.PasswordComponent;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.component.StreamSupplierComponent;
import com.speedment.runtime.core.db.DbmsMetadataHandler;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.core.exception.SpeedmentException;
import com.speedment.runtime.core.internal.component.InfoComponentImpl;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.util.DatabaseUtil;
import com.speedment.runtime.welcome.HasOnWelcome;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public abstract class AbstractApplicationBuilder<APP extends Speedment, BUILDER extends AbstractApplicationBuilder<APP, BUILDER>>
implements ApplicationBuilder<APP, BUILDER> {
    private static final Logger LOGGER = LoggerManager.getLogger((String)ApplicationBuilder.LogType.APPLICATION_BUILDER.getLoggerName());
    private final InjectorBuilder injectorBuilder;
    private boolean skipCheckDatabaseConnectivity;
    private boolean skipValidateRuntimeConfig;
    private boolean skipLogoPrintout;

    protected AbstractApplicationBuilder(Class<? extends APP> applicationImplClass, Class<? extends ApplicationMetadata> metadataClass) {
        this(Injector.builder().withBundle(RuntimeBundle.class).withComponent(applicationImplClass).withComponent(metadataClass));
    }

    protected AbstractApplicationBuilder(ClassLoader classLoader, Class<? extends APP> applicationImplClass, Class<? extends ApplicationMetadata> metadataClass) {
        this(Injector.builder((ClassLoader)classLoader).withBundle(RuntimeBundle.class).withComponent(applicationImplClass).withComponent(metadataClass));
    }

    protected AbstractApplicationBuilder(InjectorBuilder injectorBuilder) {
        this.injectorBuilder = Objects.requireNonNull(injectorBuilder);
        this.skipCheckDatabaseConnectivity = false;
        this.skipValidateRuntimeConfig = false;
    }

    public <C extends Document & HasEnabled> BUILDER with(Class<C> type, String name, BiConsumer<Injector, C> consumer) {
        NullUtil.requireNonNulls(type, (Object)name, consumer);
        this.injectorBuilder.before(ExecutionBuilder.resolved(ProjectComponent.class).withStateInitialized(Injector.class).withExecute((projComp, injector) -> DocumentDbUtil.traverseOver((Project)projComp.getProject(), (Class)type).filter(doc -> DocumentUtil.relativeName((Document)HasName.of((Document)doc), Dbms.class, (DocumentUtil.Name)DocumentUtil.Name.DATABASE_NAME).equals(name)).forEach(doc -> consumer.accept((Injector)injector, (Object)doc))));
        return this.self();
    }

    public <C extends Document & HasEnabled> BUILDER with(Class<C> type, BiConsumer<Injector, C> consumer) {
        NullUtil.requireNonNulls(type, consumer);
        this.injectorBuilder.before(ExecutionBuilder.resolved(ProjectComponent.class).withStateInitialized(Injector.class).withExecute((projComp, injector) -> DocumentDbUtil.traverseOver((Project)projComp.getProject(), (Class)type).forEach(doc -> consumer.accept((Injector)injector, (Object)doc))));
        return this.self();
    }

    public <C extends Document & HasEnabled> BUILDER with(Class<C> type, Consumer<C> consumer) {
        this.injectorBuilder.before(ExecutionBuilder.resolved(ProjectComponent.class).withExecute(projComp -> DocumentDbUtil.traverseOver((Project)projComp.getProject(), (Class)type).forEach(consumer)));
        return this.self();
    }

    public BUILDER withParam(String key, String value) {
        NullUtil.requireNonNulls((Object)key, (Object)value);
        this.injectorBuilder.withParam(key, value);
        return this.self();
    }

    public BUILDER withPassword(char[] password) {
        this.injectorBuilder.before(ExecutionBuilder.started(PasswordComponent.class).withStateResolved(ProjectComponent.class).withExecute((passComp, projComp) -> projComp.getProject().dbmses().forEach(dbms -> passComp.put(dbms, password))));
        return this.self();
    }

    public BUILDER withPassword(String dbmsName, char[] password) {
        Objects.requireNonNull(dbmsName);
        this.injectorBuilder.before(ExecutionBuilder.started(PasswordComponent.class).withExecute(passComp -> passComp.put(dbmsName, password)));
        return this.self();
    }

    public BUILDER withPassword(String password) {
        return (BUILDER)this.withPassword(password == null ? null : password.toCharArray());
    }

    public BUILDER withPassword(String dbmsName, String password) {
        Objects.requireNonNull(dbmsName);
        return (BUILDER)this.withPassword(dbmsName, password == null ? null : password.toCharArray());
    }

    public BUILDER withUsername(String username) {
        this.with((Class)Dbms.class, (T dbms) -> dbms.mutator().setUsername(username));
        return this.self();
    }

    public BUILDER withUsername(String dbmsName, String username) {
        Objects.requireNonNull(dbmsName);
        this.with(Dbms.class, dbmsName, d -> d.mutator().setUsername(username));
        return this.self();
    }

    public BUILDER withIpAddress(String ipAddress) {
        Objects.requireNonNull(ipAddress);
        this.with((Class)Dbms.class, (T d) -> d.mutator().setIpAddress(ipAddress));
        return this.self();
    }

    public BUILDER withIpAddress(String dbmsName, String ipAddress) {
        NullUtil.requireNonNulls((Object)dbmsName, (Object)ipAddress);
        this.with(Dbms.class, dbmsName, d -> d.mutator().setIpAddress(ipAddress));
        return this.self();
    }

    public BUILDER withPort(int port) {
        this.with((Class)Dbms.class, (T d) -> d.mutator().setPort(Integer.valueOf(port)));
        return this.self();
    }

    public BUILDER withPort(String dbmsName, int port) {
        Objects.requireNonNull(dbmsName);
        this.with(Dbms.class, dbmsName, d -> d.mutator().setPort(Integer.valueOf(port)));
        return this.self();
    }

    public BUILDER withSchema(String schemaName) {
        Objects.requireNonNull(schemaName);
        this.with((Class)Schema.class, (T s) -> {
            s.mutator().setId(s.getId());
            s.mutator().setName(schemaName);
        });
        return this.self();
    }

    public BUILDER withSchema(String oldSchemaName, String schemaName) {
        NullUtil.requireNonNulls((Object)oldSchemaName, (Object)schemaName);
        this.with(Schema.class, oldSchemaName, s -> {
            s.mutator().setId(s.getId());
            s.mutator().setName(schemaName);
        });
        return this.self();
    }

    public BUILDER withConnectionUrl(String connectionUrl) {
        this.with((Class)Dbms.class, (T d) -> d.mutator().setConnectionUrl(connectionUrl));
        return this.self();
    }

    public BUILDER withConnectionUrl(String dbmsName, String connectionUrl) {
        Objects.requireNonNull(dbmsName);
        this.with(Dbms.class, dbmsName, s -> s.mutator().setConnectionUrl(connectionUrl));
        return this.self();
    }

    public <M extends Manager<?>> BUILDER withManager(Class<M> managerImplType) {
        Objects.requireNonNull(managerImplType);
        AbstractApplicationBuilder.withInjectable(this.injectorBuilder, managerImplType);
        return this.self();
    }

    public BUILDER withSkipCheckDatabaseConnectivity() {
        this.skipCheckDatabaseConnectivity = true;
        return this.self();
    }

    public BUILDER withSkipValidateRuntimeConfig() {
        this.skipValidateRuntimeConfig = true;
        return this.self();
    }

    public BUILDER withSkipLogoPrintout() {
        this.skipLogoPrintout = true;
        return this.self();
    }

    public BUILDER withBundle(Class<? extends InjectBundle> bundleClass) {
        Objects.requireNonNull(bundleClass);
        this.injectorBuilder.withBundle(bundleClass);
        return this.self();
    }

    public BUILDER withComponent(Class<?> injectableClass) {
        Objects.requireNonNull(injectableClass);
        this.injectorBuilder.withComponent(injectableClass);
        return this.self();
    }

    public <T> BUILDER withComponent(Class<T> injectableClass, Supplier<T> supplier) {
        NullUtil.requireNonNulls(injectableClass, supplier);
        this.injectorBuilder.withComponent(injectableClass, supplier);
        return this.self();
    }

    public BUILDER withLogging(ApplicationBuilder.HasLoggerName namer) {
        LoggerManager.getLogger((String)namer.getLoggerName()).setLevel(Level.DEBUG);
        if (ApplicationBuilder.LogType.APPLICATION_BUILDER.getLoggerName().equals(namer.getLoggerName())) {
            Injector.logger().setLevel(Level.DEBUG);
            InjectorBuilder.logger().setLevel(Level.DEBUG);
        }
        return this.self();
    }

    public BUILDER withAllowStreamIteratorAndSpliterator() {
        this.injectorBuilder.withParam("allowStreamIteratorAndSpliterator", Boolean.TRUE.toString());
        return this.self();
    }

    public final APP build() {
        Injector inj;
        try {
            inj = this.injectorBuilder.build();
        }
        catch (CyclicReferenceException | InstantiationException ex) {
            throw new SpeedmentException("Error in dependency injection.", ex);
        }
        this.printWelcomeMessage(inj);
        if (!this.skipValidateRuntimeConfig) {
            this.validateRuntimeConfig(inj);
        }
        if (!this.skipCheckDatabaseConnectivity) {
            this.checkDatabaseConnectivity(inj);
        }
        this.printStreamSupplierOrder(inj);
        return this.build(inj);
    }

    protected abstract APP build(Injector var1);

    protected void validateRuntimeConfig(Injector injector) {
        LOGGER.debug("Validating Runtime Configuration");
        Project project = ((ProjectComponent)injector.getOrThrow(ProjectComponent.class)).getProject();
        if (project == null) {
            throw new SpeedmentException("No project defined");
        }
        project.dbmses().forEach(d -> {
            String typeName = d.getTypeName();
            Optional oDbmsType = ((DbmsHandlerComponent)injector.getOrThrow(DbmsHandlerComponent.class)).findByName(typeName);
            if (!oDbmsType.isPresent()) {
                throw new SpeedmentException("The database type " + typeName + " is not registered with the " + DbmsHandlerComponent.class.getSimpleName());
            }
            DbmsType dbmsType = (DbmsType)oDbmsType.get();
            if (!dbmsType.isSupported()) {
                LOGGER.error("The database driver class " + dbmsType.getDriverName() + " is not available. Make sure to include it in your class path (e.g. in the POM file)");
            }
        });
    }

    protected void checkDatabaseConnectivity(Injector injector) {
        LOGGER.debug("Checking Database Connectivity");
        Project project = ((ProjectComponent)injector.getOrThrow(ProjectComponent.class)).getProject();
        project.dbmses().forEachOrdered(dbms -> {
            DbmsHandlerComponent dbmsHandlerComponent = (DbmsHandlerComponent)injector.getOrThrow(DbmsHandlerComponent.class);
            DbmsType dbmsType = DatabaseUtil.dbmsTypeOf((DbmsHandlerComponent)dbmsHandlerComponent, (Dbms)dbms);
            DbmsMetadataHandler handler = dbmsType.getMetadataHandler();
            try {
                LOGGER.info(handler.getDbmsInfoString(dbms));
            }
            catch (SQLException sqle) {
                throw new SpeedmentException("Unable to establish initial connection with the database named " + dbms.getName() + ".", (Throwable)sqle);
            }
        });
    }

    protected void printWelcomeMessage(Injector injector) {
        InfoComponent info = (InfoComponent)injector.getOrThrow(InfoComponent.class);
        InfoComponentImpl upstreamInfo = (InfoComponentImpl)injector.getOrThrow(InfoComponentImpl.class);
        String title = info.getTitle();
        String version = info.getImplementationVersion();
        if (!this.skipLogoPrintout) {
            String speedmentMsg = "\n   ____                   _                     _     \n  / ___'_ __  __  __   __| |_ __ __    __ _ __ | |    \n  \\___ | '_ |/  \\/  \\ / _  | '_ \\ _ \\ /  \\ '_ \\| |_   \n   ___)| |_)| '_/ '_/| (_| | | | | | | '_/ | | |  _|  \n  |____| .__|\\__\\\\__\\ \\____|_| |_| |_|\\__\\_| |_| '_   \n=======|_|======================================\\__|==\n   :: " + title + " by " + info.getVendor() + ":: (v" + version + ") \n";
            LOGGER.info(speedmentMsg);
        }
        String msg = title + " (" + info.getSubtitle() + ") version " + version + " by " + info.getVendor() + " Specification version " + info.getSpecificationVersion() + " (" + info.getSpecificationNickname() + "), License: " + info.getLicenseName();
        LOGGER.info(msg);
        if (!info.isProductionMode()) {
            LOGGER.warn("This version is NOT INTENDED FOR PRODUCTION USE!");
        }
        if (info != upstreamInfo) {
            LOGGER.info("Upstream version is " + upstreamInfo.getImplementationVersion() + " (" + upstreamInfo.getSpecificationNickname() + ")");
            if (!upstreamInfo.isProductionMode()) {
                LOGGER.warn("Upstream version is NOT INTENDED FOR PRODUCTION USE!");
            }
        }
        try {
            String javaMsg = String.format("%s %s by %s. Implementation %s %s by %s", JvmVersion.getSpecificationTitle(), JvmVersion.getSpecificationVersion(), JvmVersion.getSpecificationVendor(), JvmVersion.getImplementationTitle(), JvmVersion.getImplementationVersion(), JvmVersion.getImplementationVendor());
            LOGGER.info(javaMsg);
            String versionString = JvmVersion.getImplementationVersion();
            Optional<Boolean> isVersionOk = this.isVersionOk();
            if (isVersionOk.isPresent()) {
                if (!isVersionOk.get().booleanValue()) {
                    LOGGER.warn("The current Java version (" + versionString + ") is outdated. Please upgrade to a more recent Java version.");
                }
            } else {
                LOGGER.warn("Unable to fully parse the java version. Version check skipped!");
            }
        }
        catch (Exception ex) {
            LOGGER.info("Unknown Java version.");
        }
        LOGGER.info("Available processors: %d, Max Memory: %,d bytes", (Object)Runtime.getRuntime().availableProcessors(), (Object)Runtime.getRuntime().maxMemory());
        injector.injectables().flatMap(arg_0 -> ((Injector)injector).stream(arg_0)).filter(HasOnWelcome.class::isInstance).map(HasOnWelcome.class::cast).forEach(HasOnWelcome::onWelcome);
    }

    private BUILDER self() {
        AbstractApplicationBuilder builder = this;
        return (BUILDER)builder;
    }

    Optional<Boolean> isVersionOk() {
        int majorVersion = JvmVersion.major();
        int securityVersion = JvmVersion.security();
        if (majorVersion == 0) {
            return Optional.empty();
        }
        if (majorVersion < 8) {
            return Optional.of(Boolean.FALSE);
        }
        if (majorVersion == 8 && securityVersion < 40) {
            return Optional.of(Boolean.FALSE);
        }
        return Optional.of(Boolean.TRUE);
    }

    private static <T> void withInjectable(InjectorBuilder injector, Class<T> injectableImplType) {
        Objects.requireNonNull(injectableImplType);
        injector.withComponent(injectableImplType);
    }

    private void printStreamSupplierOrder(Injector injector) {
        injector.get(StreamSupplierComponent.class).ifPresent(root -> {
            if (root.sourceStreamSupplierComponents().findAny().isPresent()) {
                LOGGER.info("Current " + StreamSupplierComponent.class.getSimpleName() + " hierarchy:");
                this.printStreamSupplierOrder((StreamSupplierComponent)root, 0);
            }
        });
    }

    private void printStreamSupplierOrder(StreamSupplierComponent ssc, int level) {
        LOGGER.info("%s%s (0x%08x) %s", (Object)this.indent(level), (Object)ssc.getClass().getSimpleName(), (Object)ssc.hashCode(), new Object[]{ssc.isImmutable() ? "mutable" : "immutable"});
        ssc.sourceStreamSupplierComponents().forEachOrdered(child -> this.printStreamSupplierOrder((StreamSupplierComponent)child, level + 1));
    }

    private String indent(int level) {
        return IntStream.range(0, level).collect(StringBuilder::new, (sb, i) -> sb.append("    "), StringBuilder::append).toString();
    }
}

