/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.application;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.runtime.core.Speedment;
import com.speedment.runtime.core.component.StreamSupplierComponent;
import com.speedment.runtime.core.exception.SpeedmentException;
import com.speedment.runtime.core.internal.manager.ManagerConfiguratorImpl;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.manager.ManagerConfigurator;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractSpeedment
implements Speedment {
    @Inject
    private Injector injector;

    protected AbstractSpeedment() {
    }

    public <T> Optional<T> get(Class<T> type) {
        return this.injector.get(type);
    }

    public <T> T getOrThrow(Class<T> componentClass) throws SpeedmentException {
        try {
            return (T)this.injector.getOrThrow(componentClass);
        }
        catch (IllegalArgumentException ex) {
            throw new SpeedmentException("Specified component '" + componentClass.getSimpleName() + "' is not installed in the platform.", (Throwable)ex);
        }
    }

    public <ENTITY> ManagerConfigurator<ENTITY> configure(Class<? extends Manager<ENTITY>> managerClass) {
        Objects.requireNonNull(managerClass);
        return new ManagerConfiguratorImpl(this.getOrThrow(StreamSupplierComponent.class), this.getOrThrow(managerClass));
    }

    public void close() {
        this.injector.stop();
    }
}

