/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.BooleanToDoubleFunction;
import com.speedment.common.function.BooleanUnaryOperator;
import com.speedment.common.function.ToBooleanFunction;
import com.speedment.runtime.compute.ToBoolean;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.Function;

@FunctionalInterface
public interface ToBooleanNullable<T>
extends Expression<T>,
ToBooleanFunction<T>,
ToNullable<T, Boolean, ToBoolean<T>>,
HasMapToDoubleIfPresent<T, BooleanToDoubleFunction>,
HasMapIfPresent<T, BooleanUnaryOperator, ToBooleanNullable<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToBooleanNullable<T> of(Function<T, Boolean> lambda) {
        if (lambda instanceof ToBooleanNullable) {
            return (ToBooleanNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.BOOLEAN_NULLABLE;
    }

    default public boolean applyAsBoolean(T object) throws NullPointerException {
        return (Boolean)this.apply(object);
    }

    @Override
    default public ToBoolean<T> orThrow() throws NullPointerException {
        return OrElseThrowUtil.booleanOrElseThrow(this);
    }

    @Override
    default public ToBoolean<T> orElseGet(ToBoolean<T> getter) {
        return OrElseGetUtil.booleanOrElseGet(this, getter);
    }

    @Override
    default public ToBoolean<T> orElse(Boolean value) {
        return OrElseUtil.booleanOrElse(this, value);
    }

    @Override
    default public ToDoubleNullable<T> mapToDoubleIfPresent(final BooleanToDoubleFunction mapper) {
        final ToBooleanNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T object) {
                return delegate.isNull(object) ? null : Double.valueOf(mapper.applyAsDouble(delegate.applyAsBoolean(object)));
            }

            @Override
            public double applyAsDouble(T object) throws NullPointerException {
                return mapper.applyAsDouble(delegate.applyAsBoolean(object));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsDouble(object) : mapper.applyAsDouble(delegate.applyAsBoolean(object));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return object -> delegate.isNull(object) ? value.doubleValue() : mapper.applyAsDouble(delegate.applyAsBoolean(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public ToBooleanNullable<T> mapIfPresent(final BooleanUnaryOperator mapper) {
        final ToBooleanNullable delegate = this;
        return new ToBooleanNullable<T>(){

            @Override
            public Boolean apply(T object) {
                return delegate.isNull(object) ? null : Boolean.valueOf(mapper.applyAsBoolean(delegate.applyAsBoolean(object)));
            }

            @Override
            public boolean applyAsBoolean(T object) throws NullPointerException {
                return mapper.applyAsBoolean(delegate.applyAsBoolean(object));
            }

            @Override
            public ToBoolean<T> orElseGet(ToBoolean<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsBoolean(object) : mapper.applyAsBoolean(delegate.applyAsBoolean(object));
            }

            @Override
            public ToBoolean<T> orElse(Boolean value) {
                return object -> delegate.isNull(object) ? value.booleanValue() : mapper.applyAsBoolean(delegate.applyAsBoolean(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public long hash(T object) {
        return this.isNull(object) ? 0L : (long)(this.applyAsBoolean(object) ? 1 : 2);
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Boolean.compare(this.applyAsBoolean(first), this.applyAsBoolean(second));
    }

    @Override
    default public <V> ToBooleanNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToBooleanNullable(casted, this);
    }
}

