/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.ByteToDoubleFunction;
import com.speedment.common.function.ByteUnaryOperator;
import com.speedment.common.function.ToByteFunction;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.Function;

@FunctionalInterface
public interface ToByteNullable<T>
extends Expression<T>,
ToByteFunction<T>,
ToNullable<T, Byte, ToByte<T>>,
HasAbs<ToByteNullable<T>>,
HasSign<ToByteNullable<T>>,
HasSqrt<ToDoubleNullable<T>>,
HasNegate<ToByteNullable<T>>,
HasMapToDoubleIfPresent<T, ByteToDoubleFunction>,
HasMapIfPresent<T, ByteUnaryOperator, ToByteNullable<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToByteNullable<T> of(Function<T, Byte> lambda) {
        if (lambda instanceof ToByteNullable) {
            return (ToByteNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.BYTE_NULLABLE;
    }

    default public byte applyAsByte(T object) throws NullPointerException {
        return (Byte)this.apply(object);
    }

    @Override
    default public ToByte<T> orThrow() throws NullPointerException {
        return OrElseThrowUtil.byteOrElseThrow(this);
    }

    @Override
    default public ToByte<T> orElseGet(ToByte<T> getter) {
        return OrElseGetUtil.byteOrElseGet(this, getter);
    }

    @Override
    default public ToByte<T> orElse(Byte value) {
        return OrElseUtil.byteOrElse(this, value);
    }

    @Override
    default public ToByteNullable<T> abs() {
        return Expressions.absOrNull(this);
    }

    @Override
    default public ToByteNullable<T> negate() {
        return Expressions.negateOrNull(this);
    }

    @Override
    default public ToByteNullable<T> sign() {
        return Expressions.signOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> sqrt() {
        return Expressions.sqrtOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> mapToDoubleIfPresent(final ByteToDoubleFunction mapper) {
        final ToByteNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T object) {
                return delegate.isNull(object) ? null : Double.valueOf(mapper.applyAsDouble(delegate.applyAsByte(object)));
            }

            @Override
            public double applyAsDouble(T object) throws NullPointerException {
                return mapper.applyAsDouble(delegate.applyAsByte(object));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsDouble(object) : mapper.applyAsDouble(delegate.applyAsByte(object));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return object -> delegate.isNull(object) ? value.doubleValue() : mapper.applyAsDouble(delegate.applyAsByte(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public ToByteNullable<T> mapIfPresent(final ByteUnaryOperator mapper) {
        final ToByteNullable delegate = this;
        return new ToByteNullable<T>(){

            @Override
            public Byte apply(T object) {
                return delegate.isNull(object) ? null : Byte.valueOf(mapper.applyAsByte(delegate.applyAsByte(object)));
            }

            @Override
            public byte applyAsByte(T object) throws NullPointerException {
                return mapper.applyAsByte(delegate.applyAsByte(object));
            }

            @Override
            public ToByte<T> orElseGet(ToByte<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsByte(object) : mapper.applyAsByte(delegate.applyAsByte(object));
            }

            @Override
            public ToByte<T> orElse(Byte value) {
                return object -> delegate.isNull(object) ? value.byteValue() : mapper.applyAsByte(delegate.applyAsByte(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public long hash(T object) {
        return this.isNull(object) ? 0L : (long)this.applyAsByte(object);
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Byte.compare(this.applyAsByte(first), this.applyAsByte(second));
    }

    @Override
    default public <V> ToByteNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToByteNullable(casted, this);
    }
}

