/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

@FunctionalInterface
public interface ToDoubleNullable<T>
extends Expression<T>,
ToDoubleFunction<T>,
ToNullable<T, Double, ToDouble<T>>,
HasAbs<ToDoubleNullable<T>>,
HasSign<ToByteNullable<T>>,
HasSqrt<ToDoubleNullable<T>>,
HasNegate<ToDoubleNullable<T>>,
HasMapIfPresent<T, DoubleUnaryOperator, ToDoubleNullable<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToDoubleNullable<T> of(Function<T, Double> lambda) {
        if (lambda instanceof ToDoubleNullable) {
            return (ToDoubleNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.DOUBLE_NULLABLE;
    }

    @Override
    default public double applyAsDouble(T object) throws NullPointerException {
        return (Double)this.apply(object);
    }

    @Override
    default public ToDouble<T> orThrow() throws NullPointerException {
        return OrElseThrowUtil.doubleOrElseThrow(this);
    }

    @Override
    default public ToDouble<T> orElseGet(ToDouble<T> getter) {
        return OrElseGetUtil.doubleOrElseGet(this, getter);
    }

    @Override
    default public ToDouble<T> orElse(Double value) {
        return OrElseUtil.doubleOrElse(this, value);
    }

    @Override
    default public ToDoubleNullable<T> abs() {
        return Expressions.absOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> negate() {
        return Expressions.negateOrNull(this);
    }

    @Override
    default public ToByteNullable<T> sign() {
        return Expressions.signOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> sqrt() {
        return Expressions.sqrtOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> mapIfPresent(final DoubleUnaryOperator operator) {
        final ToDoubleNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T t) {
                return delegate.isNull(t) ? null : Double.valueOf(operator.applyAsDouble(delegate.applyAsDouble(t)));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return t -> delegate.isNull(t) ? getter.applyAsDouble(t) : operator.applyAsDouble(delegate.applyAsDouble(t));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return t -> delegate.isNull(t) ? value.doubleValue() : operator.applyAsDouble(delegate.applyAsDouble(t));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }

            @Override
            public ToDoubleNullable<T> mapIfPresent(DoubleUnaryOperator nextOperator) {
                return delegate.mapIfPresent(operator.andThen(nextOperator));
            }
        };
    }

    @Override
    default public long hash(T object) {
        if (this.isNull(object)) {
            return 0L;
        }
        long l = Double.doubleToLongBits(this.applyAsDouble(object));
        return (int)(l ^ l >>> 32);
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Double.compare(this.applyAsDouble(first), this.applyAsDouble(second));
    }

    @Override
    default public <V> ToDoubleNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToDoubleNullable(casted, this);
    }
}

