/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.Function;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface ToLongNullable<T>
extends Expression<T>,
ToNullable<T, Long, ToLong<T>>,
ToLongFunction<T>,
HasAbs<ToLongNullable<T>>,
HasSign<ToByteNullable<T>>,
HasSqrt<ToDoubleNullable<T>>,
HasNegate<ToLongNullable<T>>,
HasMapToDoubleIfPresent<T, LongToDoubleFunction>,
HasMapIfPresent<T, LongUnaryOperator, ToLongNullable<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToLongNullable<T> of(Function<T, Long> lambda) {
        if (lambda instanceof ToLongNullable) {
            return (ToLongNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.LONG_NULLABLE;
    }

    @Override
    default public long applyAsLong(T object) throws NullPointerException {
        return (Long)this.apply(object);
    }

    @Override
    default public ToLong<T> orThrow() throws NullPointerException {
        return OrElseThrowUtil.longOrElseThrow(this);
    }

    @Override
    default public ToLong<T> orElseGet(ToLong<T> getter) {
        return OrElseGetUtil.longOrElseGet(this, getter);
    }

    @Override
    default public ToLong<T> orElse(Long value) {
        return OrElseUtil.longOrElse(this, value);
    }

    @Override
    default public ToLongNullable<T> abs() {
        return Expressions.absOrNull(this);
    }

    @Override
    default public ToLongNullable<T> negate() {
        return Expressions.negateOrNull(this);
    }

    @Override
    default public ToByteNullable<T> sign() {
        return Expressions.signOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> sqrt() {
        return Expressions.sqrtOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> mapToDoubleIfPresent(final LongToDoubleFunction mapper) {
        final ToLongNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T object) {
                return delegate.isNull(object) ? null : Double.valueOf(mapper.applyAsDouble(delegate.applyAsLong(object)));
            }

            @Override
            public double applyAsDouble(T object) throws NullPointerException {
                return mapper.applyAsDouble(delegate.applyAsLong(object));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsDouble(object) : mapper.applyAsDouble(delegate.applyAsLong(object));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return object -> delegate.isNull(object) ? value.doubleValue() : mapper.applyAsDouble(delegate.applyAsLong(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public ToLongNullable<T> mapIfPresent(final LongUnaryOperator mapper) {
        final ToLongNullable delegate = this;
        return new ToLongNullable<T>(){

            @Override
            public Long apply(T object) {
                return delegate.isNull(object) ? null : Long.valueOf(mapper.applyAsLong(delegate.applyAsLong(object)));
            }

            @Override
            public long applyAsLong(T object) throws NullPointerException {
                return mapper.applyAsLong(delegate.applyAsLong(object));
            }

            @Override
            public ToLong<T> orElseGet(ToLong<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsLong(object) : mapper.applyAsLong(delegate.applyAsLong(object));
            }

            @Override
            public ToLong<T> orElse(Long value) {
                return object -> delegate.isNull(object) ? value.longValue() : mapper.applyAsLong(delegate.applyAsLong(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public long hash(T object) {
        if (this.isNull(object)) {
            return 0L;
        }
        long l = this.applyAsLong(object);
        return (int)(l ^ l >>> 32);
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Long.compare(this.applyAsLong(first), this.applyAsLong(second));
    }

    @Override
    default public <V> ToLongNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToLongNullable(casted, this);
    }
}

