/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.ShortToDoubleFunction;
import com.speedment.common.function.ShortUnaryOperator;
import com.speedment.common.function.ToShortFunction;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.Function;

@FunctionalInterface
public interface ToShortNullable<T>
extends Expression<T>,
ToShortFunction<T>,
ToNullable<T, Short, ToShort<T>>,
HasAbs<ToShortNullable<T>>,
HasSign<ToByteNullable<T>>,
HasSqrt<ToDoubleNullable<T>>,
HasNegate<ToShortNullable<T>>,
HasMapToDoubleIfPresent<T, ShortToDoubleFunction>,
HasMapIfPresent<T, ShortUnaryOperator, ToShortNullable<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToShortNullable<T> of(Function<T, Short> lambda) {
        if (lambda instanceof ToShortNullable) {
            return (ToShortNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.SHORT_NULLABLE;
    }

    default public short applyAsShort(T object) throws NullPointerException {
        return (Short)this.apply(object);
    }

    @Override
    default public ToShort<T> orThrow() throws NullPointerException {
        return OrElseThrowUtil.shortOrElseThrow(this);
    }

    @Override
    default public ToShort<T> orElseGet(ToShort<T> getter) {
        return OrElseGetUtil.shortOrElseGet(this, getter);
    }

    @Override
    default public ToShort<T> orElse(Short value) {
        return OrElseUtil.shortOrElse(this, value);
    }

    @Override
    default public ToShortNullable<T> abs() {
        return Expressions.absOrNull(this);
    }

    @Override
    default public ToShortNullable<T> negate() {
        return Expressions.negateOrNull(this);
    }

    @Override
    default public ToByteNullable<T> sign() {
        return Expressions.signOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> sqrt() {
        return Expressions.sqrtOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> mapToDoubleIfPresent(final ShortToDoubleFunction mapper) {
        final ToShortNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T object) {
                return delegate.isNull(object) ? null : Double.valueOf(mapper.applyAsDouble(delegate.applyAsShort(object)));
            }

            @Override
            public double applyAsDouble(T object) throws NullPointerException {
                return mapper.applyAsDouble(delegate.applyAsShort(object));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsDouble(object) : mapper.applyAsDouble(delegate.applyAsShort(object));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return object -> delegate.isNull(object) ? value.doubleValue() : mapper.applyAsDouble(delegate.applyAsShort(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public ToShortNullable<T> mapIfPresent(final ShortUnaryOperator mapper) {
        final ToShortNullable delegate = this;
        return new ToShortNullable<T>(){

            @Override
            public Short apply(T object) {
                return delegate.isNull(object) ? null : Short.valueOf(mapper.applyAsShort(delegate.applyAsShort(object)));
            }

            @Override
            public short applyAsShort(T object) throws NullPointerException {
                return mapper.applyAsShort(delegate.applyAsShort(object));
            }

            @Override
            public ToShort<T> orElseGet(ToShort<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsShort(object) : mapper.applyAsShort(delegate.applyAsShort(object));
            }

            @Override
            public ToShort<T> orElse(Short value) {
                return object -> delegate.isNull(object) ? value.shortValue() : mapper.applyAsShort(delegate.applyAsShort(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public long hash(T object) {
        return this.isNull(object) ? 0L : (long)this.applyAsShort(object);
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Short.compare(this.applyAsShort(first), this.applyAsShort(second));
    }

    @Override
    default public <V> ToShortNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToShortNullable(casted, this);
    }
}

