/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.common.function.ByteToDoubleFunction;
import com.speedment.common.function.ByteUnaryOperator;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.expression.NullableExpression;
import java.util.Objects;
import java.util.function.Predicate;

public final class ToByteNullableImpl<T>
implements NullableExpression<T, ToByte<T>>,
ToByteNullable<T> {
    private final ToByte<T> original;
    private final Predicate<T> isNull;

    public ToByteNullableImpl(ToByte<T> original, Predicate<T> isNull) {
        this.original = Objects.requireNonNull(original);
        this.isNull = Objects.requireNonNull(isNull);
    }

    @Override
    public ToByte<T> inner() {
        return this.original;
    }

    @Override
    public Predicate<T> isNullPredicate() {
        return this.isNull;
    }

    @Override
    public Byte apply(T t) {
        return this.isNull.test(t) ? null : Byte.valueOf(this.original.applyAsByte(t));
    }

    @Override
    public byte applyAsByte(T t) throws NullPointerException {
        return this.original.applyAsByte(t);
    }

    @Override
    public ToByte<T> orThrow() throws NullPointerException {
        return this.original;
    }

    @Override
    public ToByte<T> orElseGet(ToByte<T> getter) {
        return t -> this.isNull.test(t) ? getter.applyAsByte(t) : this.original.applyAsByte(t);
    }

    @Override
    public ToByte<T> orElse(Byte value) {
        return t -> this.isNull.test(t) ? value.byteValue() : this.original.applyAsByte(t);
    }

    @Override
    public ToDoubleNullable<T> mapToDoubleIfPresent(ByteToDoubleFunction mapper) {
        return t -> this.isNull.test(t) ? null : Double.valueOf(mapper.applyAsDouble(this.original.applyAsByte(t)));
    }

    @Override
    public ToByteNullable<T> mapIfPresent(ByteUnaryOperator mapper) {
        return t -> this.isNull.test(t) ? null : Byte.valueOf(mapper.applyAsByte(this.original.applyAsByte(t)));
    }

    @Override
    public long hash(T object) {
        return this.isNull.test(object) ? 256L : (long)this.original.applyAsByte(object);
    }

    @Override
    public int compare(T first, T second) {
        boolean f = this.isNull(first);
        boolean s = this.isNull(second);
        if (f && s) {
            return 0;
        }
        if (f) {
            return 1;
        }
        if (s) {
            return -1;
        }
        return Byte.compare(this.original.applyAsByte(first), this.original.applyAsByte(second));
    }

    @Override
    public boolean isNull(T object) {
        return this.isNull.test(object);
    }

    @Override
    public boolean isNotNull(T object) {
        return !this.isNull.test(object);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullableExpression)) {
            return false;
        }
        NullableExpression that = (NullableExpression)o;
        return Objects.equals(this.original, that.inner()) && Objects.equals(this.isNull, that.isNullPredicate());
    }

    public int hashCode() {
        return Objects.hash(this.original, this.isNull);
    }
}

