/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.expression.NullableExpression;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;

public final class ToDoubleNullableImpl<T>
implements NullableExpression<T, ToDouble<T>>,
ToDoubleNullable<T> {
    private final ToDouble<T> original;
    private final Predicate<T> isNull;

    public ToDoubleNullableImpl(ToDouble<T> original, Predicate<T> isNull) {
        this.original = Objects.requireNonNull(original);
        this.isNull = Objects.requireNonNull(isNull);
    }

    @Override
    public ToDouble<T> inner() {
        return this.original;
    }

    @Override
    public Predicate<T> isNullPredicate() {
        return this.isNull;
    }

    @Override
    public Double apply(T t) {
        return this.isNull.test(t) ? null : Double.valueOf(this.original.applyAsDouble(t));
    }

    @Override
    public double applyAsDouble(T t) throws NullPointerException {
        return this.original.applyAsDouble(t);
    }

    @Override
    public ToDouble<T> orThrow() throws NullPointerException {
        return this.original;
    }

    @Override
    public ToDouble<T> orElseGet(ToDouble<T> getter) {
        return t -> this.isNull.test(t) ? getter.applyAsDouble(t) : this.original.applyAsDouble(t);
    }

    @Override
    public ToDouble<T> orElse(Double value) {
        return t -> this.isNull.test(t) ? value.doubleValue() : this.original.applyAsDouble(t);
    }

    @Override
    public ToDoubleNullable<T> mapIfPresent(DoubleUnaryOperator mapper) {
        return t -> this.isNull.test(t) ? null : Double.valueOf(mapper.applyAsDouble(this.original.applyAsDouble(t)));
    }

    @Override
    public long hash(T object) {
        return Double.doubleToLongBits(this.isNull.test(object) ? Double.NEGATIVE_INFINITY : (double)Double.doubleToLongBits(this.original.applyAsDouble(object)));
    }

    @Override
    public int compare(T first, T second) {
        boolean f = this.isNull(first);
        boolean s = this.isNull(second);
        if (f && s) {
            return 0;
        }
        if (f) {
            return 1;
        }
        if (s) {
            return -1;
        }
        return Double.compare(this.original.applyAsDouble(first), this.original.applyAsDouble(second));
    }

    @Override
    public boolean isNull(T object) {
        return this.isNull.test(object);
    }

    @Override
    public boolean isNotNull(T object) {
        return !this.isNull.test(object);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullableExpression)) {
            return false;
        }
        NullableExpression that = (NullableExpression)o;
        return Objects.equals(this.original, that.inner()) && Objects.equals(this.isNull, that.isNullPredicate());
    }

    public int hashCode() {
        return Objects.hash(this.original, this.isNull);
    }
}

