/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.common.function.FloatToDoubleFunction;
import com.speedment.common.function.FloatUnaryOperator;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.expression.NullableExpression;
import java.util.Objects;
import java.util.function.Predicate;

public final class ToFloatNullableImpl<T>
implements NullableExpression<T, ToFloat<T>>,
ToFloatNullable<T> {
    private final ToFloat<T> original;
    private final Predicate<T> isNull;

    public ToFloatNullableImpl(ToFloat<T> original, Predicate<T> isNull) {
        this.original = Objects.requireNonNull(original);
        this.isNull = Objects.requireNonNull(isNull);
    }

    @Override
    public ToFloat<T> inner() {
        return this.original;
    }

    @Override
    public Predicate<T> isNullPredicate() {
        return this.isNull;
    }

    @Override
    public Float apply(T t) {
        return this.isNull.test(t) ? null : Float.valueOf(this.original.applyAsFloat(t));
    }

    @Override
    public float applyAsFloat(T t) throws NullPointerException {
        return this.original.applyAsFloat(t);
    }

    @Override
    public ToFloat<T> orThrow() throws NullPointerException {
        return this.original;
    }

    @Override
    public ToFloat<T> orElseGet(ToFloat<T> getter) {
        return t -> this.isNull.test(t) ? getter.applyAsFloat(t) : this.original.applyAsFloat(t);
    }

    @Override
    public ToFloat<T> orElse(Float value) {
        return t -> this.isNull.test(t) ? value.floatValue() : this.original.applyAsFloat(t);
    }

    @Override
    public ToDoubleNullable<T> mapToDoubleIfPresent(FloatToDoubleFunction mapper) {
        return t -> this.isNull.test(t) ? null : Double.valueOf(mapper.applyAsDouble(this.original.applyAsFloat(t)));
    }

    @Override
    public ToFloatNullable<T> mapIfPresent(FloatUnaryOperator mapper) {
        return t -> this.isNull.test(t) ? null : Float.valueOf(mapper.applyAsFloat(this.original.applyAsFloat(t)));
    }

    @Override
    public long hash(T object) {
        return this.isNull.test(object) ? 0x100000000L : (long)Float.floatToIntBits(this.original.applyAsFloat(object));
    }

    @Override
    public int compare(T first, T second) {
        boolean f = this.isNull(first);
        boolean s = this.isNull(second);
        if (f && s) {
            return 0;
        }
        if (f) {
            return 1;
        }
        if (s) {
            return -1;
        }
        return Float.compare(this.original.applyAsFloat(first), this.original.applyAsFloat(second));
    }

    @Override
    public boolean isNull(T object) {
        return this.isNull.test(object);
    }

    @Override
    public boolean isNotNull(T object) {
        return !this.isNull.test(object);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullableExpression)) {
            return false;
        }
        NullableExpression that = (NullableExpression)o;
        return Objects.equals(this.original, that.inner()) && Objects.equals(this.isNull, that.isNullPredicate());
    }

    public int hashCode() {
        return Objects.hash(this.original, this.isNull);
    }
}

