/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.expression.NullableExpression;
import java.util.Objects;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;

public final class ToIntNullableImpl<T>
implements NullableExpression<T, ToInt<T>>,
ToIntNullable<T> {
    private final ToInt<T> original;
    private final Predicate<T> isNull;

    public ToIntNullableImpl(ToInt<T> original, Predicate<T> isNull) {
        this.original = Objects.requireNonNull(original);
        this.isNull = Objects.requireNonNull(isNull);
    }

    @Override
    public ToInt<T> inner() {
        return this.original;
    }

    @Override
    public Predicate<T> isNullPredicate() {
        return this.isNull;
    }

    @Override
    public Integer apply(T t) {
        return this.isNull.test(t) ? null : Integer.valueOf(this.original.applyAsInt(t));
    }

    @Override
    public int applyAsInt(T t) throws NullPointerException {
        return this.original.applyAsInt(t);
    }

    @Override
    public ToInt<T> orThrow() throws NullPointerException {
        return this.original;
    }

    @Override
    public ToInt<T> orElseGet(ToInt<T> getter) {
        return t -> this.isNull.test(t) ? getter.applyAsInt(t) : this.original.applyAsInt(t);
    }

    @Override
    public ToInt<T> orElse(Integer value) {
        return t -> this.isNull.test(t) ? value.intValue() : this.original.applyAsInt(t);
    }

    @Override
    public ToDoubleNullable<T> mapToDoubleIfPresent(IntToDoubleFunction mapper) {
        return t -> this.isNull.test(t) ? null : Double.valueOf(mapper.applyAsDouble(this.original.applyAsInt(t)));
    }

    @Override
    public ToIntNullable<T> mapIfPresent(IntUnaryOperator mapper) {
        return t -> this.isNull.test(t) ? null : Integer.valueOf(mapper.applyAsInt(this.original.applyAsInt(t)));
    }

    @Override
    public long hash(T object) {
        return this.isNull.test(object) ? 0x100000000L : (long)this.original.applyAsInt(object);
    }

    @Override
    public int compare(T first, T second) {
        boolean f = this.isNull(first);
        boolean s = this.isNull(second);
        if (f && s) {
            return 0;
        }
        if (f) {
            return 1;
        }
        if (s) {
            return -1;
        }
        return Integer.compare(this.original.applyAsInt(first), this.original.applyAsInt(second));
    }

    @Override
    public boolean isNull(T object) {
        return this.isNull.test(object);
    }

    @Override
    public boolean isNotNull(T object) {
        return !this.isNull.test(object);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullableExpression)) {
            return false;
        }
        NullableExpression that = (NullableExpression)o;
        return Objects.equals(this.original, that.inner()) && Objects.equals(this.isNull, that.isNullPredicate());
    }

    public int hashCode() {
        return Objects.hash(this.original, this.isNull);
    }
}

