/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.expression.NullableExpression;
import java.util.Objects;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;

public final class ToLongNullableImpl<T>
implements NullableExpression<T, ToLong<T>>,
ToLongNullable<T> {
    private final ToLong<T> original;
    private final Predicate<T> isNull;

    public ToLongNullableImpl(ToLong<T> original, Predicate<T> isNull) {
        this.original = Objects.requireNonNull(original);
        this.isNull = Objects.requireNonNull(isNull);
    }

    @Override
    public ToLong<T> inner() {
        return this.original;
    }

    @Override
    public Predicate<T> isNullPredicate() {
        return this.isNull;
    }

    @Override
    public Long apply(T t) {
        return this.isNull.test(t) ? null : Long.valueOf(this.original.applyAsLong(t));
    }

    @Override
    public long applyAsLong(T t) throws NullPointerException {
        return this.original.applyAsLong(t);
    }

    @Override
    public ToLong<T> orThrow() throws NullPointerException {
        return this.original;
    }

    @Override
    public ToLong<T> orElseGet(ToLong<T> getter) {
        return t -> this.isNull.test(t) ? getter.applyAsLong(t) : this.original.applyAsLong(t);
    }

    @Override
    public ToLong<T> orElse(Long value) {
        return t -> this.isNull.test(t) ? value.longValue() : this.original.applyAsLong(t);
    }

    @Override
    public ToDoubleNullable<T> mapToDoubleIfPresent(LongToDoubleFunction mapper) {
        return t -> this.isNull.test(t) ? null : Double.valueOf(mapper.applyAsDouble(this.original.applyAsLong(t)));
    }

    @Override
    public ToLongNullable<T> mapIfPresent(LongUnaryOperator mapper) {
        return t -> this.isNull.test(t) ? null : Long.valueOf(mapper.applyAsLong(this.original.applyAsLong(t)));
    }

    @Override
    public long hash(T object) {
        return this.isNull.test(object) ? -1L : this.original.applyAsLong(object);
    }

    @Override
    public int compare(T first, T second) {
        boolean f = this.isNull(first);
        boolean s = this.isNull(second);
        if (f && s) {
            return 0;
        }
        if (f) {
            return 1;
        }
        if (s) {
            return -1;
        }
        return Long.compare(this.original.applyAsLong(first), this.original.applyAsLong(second));
    }

    @Override
    public boolean isNull(T object) {
        return this.isNull.test(object);
    }

    @Override
    public boolean isNotNull(T object) {
        return !this.isNull.test(object);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullableExpression)) {
            return false;
        }
        NullableExpression that = (NullableExpression)o;
        return Objects.equals(this.original, that.inner()) && Objects.equals(this.isNull, that.isNullPredicate());
    }

    public int hashCode() {
        return Objects.hash(this.original, this.isNull);
    }
}

