/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.common.function.ShortToDoubleFunction;
import com.speedment.common.function.ShortUnaryOperator;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.expression.NullableExpression;
import java.util.Objects;
import java.util.function.Predicate;

public final class ToShortNullableImpl<T>
implements NullableExpression<T, ToShort<T>>,
ToShortNullable<T> {
    private final ToShort<T> original;
    private final Predicate<T> isNull;

    public ToShortNullableImpl(ToShort<T> original, Predicate<T> isNull) {
        this.original = Objects.requireNonNull(original);
        this.isNull = Objects.requireNonNull(isNull);
    }

    @Override
    public ToShort<T> inner() {
        return this.original;
    }

    @Override
    public Predicate<T> isNullPredicate() {
        return this.isNull;
    }

    @Override
    public Short apply(T t) {
        return this.isNull.test(t) ? null : Short.valueOf(this.original.applyAsShort(t));
    }

    @Override
    public short applyAsShort(T t) throws NullPointerException {
        return this.original.applyAsShort(t);
    }

    @Override
    public ToShort<T> orThrow() throws NullPointerException {
        return this.original;
    }

    @Override
    public ToShort<T> orElseGet(ToShort<T> getter) {
        return t -> this.isNull.test(t) ? getter.applyAsShort(t) : this.original.applyAsShort(t);
    }

    @Override
    public ToShort<T> orElse(Short value) {
        return t -> this.isNull.test(t) ? value.shortValue() : this.original.applyAsShort(t);
    }

    @Override
    public ToDoubleNullable<T> mapToDoubleIfPresent(ShortToDoubleFunction mapper) {
        return t -> this.isNull.test(t) ? null : Double.valueOf(mapper.applyAsDouble(this.original.applyAsShort(t)));
    }

    @Override
    public ToShortNullable<T> mapIfPresent(ShortUnaryOperator mapper) {
        return t -> this.isNull.test(t) ? null : Short.valueOf(mapper.applyAsShort(this.original.applyAsShort(t)));
    }

    @Override
    public long hash(T object) {
        return this.isNull.test(object) ? 65536L : (long)this.original.applyAsShort(object);
    }

    @Override
    public int compare(T first, T second) {
        boolean f = this.isNull(first);
        boolean s = this.isNull(second);
        if (f && s) {
            return 0;
        }
        if (f) {
            return 1;
        }
        if (s) {
            return -1;
        }
        return Short.compare(this.original.applyAsShort(first), this.original.applyAsShort(second));
    }

    @Override
    public boolean isNull(T object) {
        return this.isNull.test(object);
    }

    @Override
    public boolean isNotNull(T object) {
        return !this.isNull.test(object);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullableExpression)) {
            return false;
        }
        NullableExpression that = (NullableExpression)o;
        return Objects.equals(this.original, that.inner()) && Objects.equals(this.isNull, that.isNullPredicate());
    }

    public int hashCode() {
        return Objects.hash(this.original, this.isNull);
    }
}

