/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToBigDecimal;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.UnaryExpression;
import com.speedment.runtime.compute.internal.ToByteNullableImpl;
import com.speedment.runtime.compute.internal.ToDoubleNullableImpl;
import com.speedment.runtime.compute.internal.ToFloatNullableImpl;
import com.speedment.runtime.compute.internal.ToIntNullableImpl;
import com.speedment.runtime.compute.internal.ToLongNullableImpl;
import com.speedment.runtime.compute.internal.ToShortNullableImpl;
import java.math.BigDecimal;
import java.util.Objects;

public final class AbsUtil {
    public static <T> ToByte<T> absByte(ToByte<T> expression) {
        class AbsByte
        extends AbstractAbs<T, ToByte<T>>
        implements ToByte<T> {
            AbsByte(ToByte<T> inner) {
                super(inner, null);
            }

            @Override
            public byte applyAsByte(T object) {
                byte value = ((ToByte)this.inner).applyAsByte(object);
                return value < 0 ? (byte)(-value) : value;
            }
        }
        return new AbsByte(expression);
    }

    public static <T> ToShort<T> absShort(ToShort<T> expression) {
        class AbsShort
        extends AbstractAbs<T, ToShort<T>>
        implements ToShort<T> {
            AbsShort(ToShort<T> inner) {
                super(inner, null);
            }

            @Override
            public short applyAsShort(T object) {
                short value = ((ToShort)this.inner).applyAsShort(object);
                return value < 0 ? (short)(-value) : value;
            }
        }
        return new AbsShort(expression);
    }

    public static <T> ToInt<T> absInt(ToInt<T> expression) {
        class AbsInt
        extends AbstractAbs<T, ToInt<T>>
        implements ToInt<T> {
            AbsInt(ToInt<T> inner) {
                super(inner, null);
            }

            @Override
            public int applyAsInt(T object) {
                int value = ((ToInt)this.inner).applyAsInt(object);
                return value < 0 ? -value : value;
            }
        }
        return new AbsInt(expression);
    }

    public static <T> ToLong<T> absLong(ToLong<T> expression) {
        class AbsLong
        extends AbstractAbs<T, ToLong<T>>
        implements ToLong<T> {
            AbsLong(ToLong<T> inner) {
                super(inner, null);
            }

            @Override
            public long applyAsLong(T object) {
                long value = ((ToLong)this.inner).applyAsLong(object);
                return value < 0L ? -value : value;
            }
        }
        return new AbsLong(expression);
    }

    public static <T> ToFloat<T> absFloat(ToFloat<T> expression) {
        class AbsFloat
        extends AbstractAbs<T, ToFloat<T>>
        implements ToFloat<T> {
            AbsFloat(ToFloat<T> inner) {
                super(inner, null);
            }

            @Override
            public float applyAsFloat(T object) {
                float value = ((ToFloat)this.inner).applyAsFloat(object);
                return value < 0.0f ? -value : value;
            }
        }
        return new AbsFloat(expression);
    }

    public static <T> ToDouble<T> absDouble(ToDouble<T> expression) {
        class AbsDouble
        extends AbstractAbs<T, ToDouble<T>>
        implements ToDouble<T> {
            AbsDouble(ToDouble<T> inner) {
                super(inner, null);
            }

            @Override
            public double applyAsDouble(T object) {
                double value = ((ToDouble)this.inner).applyAsDouble(object);
                return value < 0.0 ? -value : value;
            }
        }
        return new AbsDouble(expression);
    }

    public static <T> ToBigDecimal<T> absBigDecimal(ToBigDecimal<T> expression) {
        class AbsBigDecimal
        extends AbstractAbs<T, ToBigDecimal<T>>
        implements ToBigDecimal<T> {
            AbsBigDecimal(ToBigDecimal<T> inner) {
                super(inner, null);
            }

            @Override
            public BigDecimal apply(T object) {
                return ((BigDecimal)((ToBigDecimal)this.inner).apply(object)).abs();
            }
        }
        return new AbsBigDecimal(expression);
    }

    public static <T> ToByteNullable<T> absByteOrNull(ToByteNullable<T> expression) {
        return new ToByteNullableImpl<T>(AbsUtil.absByte(expression.orThrow()), expression.isNull());
    }

    public static <T> ToShortNullable<T> absShortOrNull(ToShortNullable<T> expression) {
        return new ToShortNullableImpl<T>(AbsUtil.absShort(expression.orThrow()), expression.isNull());
    }

    public static <T> ToIntNullable<T> absIntOrNull(ToIntNullable<T> expression) {
        return new ToIntNullableImpl<T>(AbsUtil.absInt(expression.orThrow()), expression.isNull());
    }

    public static <T> ToLongNullable<T> absLongOrNull(ToLongNullable<T> expression) {
        return new ToLongNullableImpl<T>(AbsUtil.absLong(expression.orThrow()), expression.isNull());
    }

    public static <T> ToFloatNullable<T> absFloatOrNull(ToFloatNullable<T> expression) {
        return new ToFloatNullableImpl<T>(AbsUtil.absFloat(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> absDoubleOrNull(ToDoubleNullable<T> expression) {
        return new ToDoubleNullableImpl<T>(AbsUtil.absDouble(expression.orThrow()), expression.isNull());
    }

    private AbsUtil() {
    }

    private static abstract class AbstractAbs<T, INNER extends Expression<T>>
    implements UnaryExpression<T, INNER> {
        final INNER inner;

        private AbstractAbs(INNER inner) {
            this.inner = (Expression)Objects.requireNonNull(inner);
        }

        @Override
        public final INNER inner() {
            return this.inner;
        }

        @Override
        public final UnaryExpression.Operator operator() {
            return UnaryExpression.Operator.ABS;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnaryExpression)) {
                return false;
            }
            UnaryExpression that = (UnaryExpression)o;
            return Objects.equals(this.inner(), that.inner()) && this.operator().equals((Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner(), this.operator()});
        }

        /* synthetic */ AbstractAbs(Expression x0, 1 x1) {
            this(x0);
        }
    }
}

